/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.server;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.CommonServicesDescription;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.adminservices.rest.ConnectionResponse;
import org.odpi.openmetadata.adminservices.server.OMAGServerAdminStoreServices;
import org.odpi.openmetadata.adminservices.server.OMAGServerErrorHandler;
import org.odpi.openmetadata.adminservices.server.OMAGServerExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.slf4j.LoggerFactory;

public class OMAGServerAdminSecurityServices {
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(OMAGServerAdminSecurityServices.class), CommonServicesDescription.ADMINISTRATION_SERVICES.getServiceName());
    private final OMAGServerExceptionHandler exceptionHandler = new OMAGServerExceptionHandler();
    private final OMAGServerErrorHandler errorHandler = new OMAGServerErrorHandler();
    private final OMAGServerAdminStoreServices configStore = new OMAGServerAdminStoreServices();

    public synchronized VoidResponse setServerSecurityConnection(String userId, String serverName, Connection connection) {
        String methodName = "setServerSecurityConnection";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setServerSecurityConnection");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setServerSecurityConnection");
            this.errorHandler.validateUserId(userId, serverName, "setServerSecurityConnection");
            this.errorHandler.validateServerConnection(connection, serverName, "setServerSecurityConnection");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "setServerSecurityConnection");
            serverConfig.setServerSecurityConnection(connection);
            ArrayList<CallSite> configAuditTrail = serverConfig.getAuditTrail();
            if (configAuditTrail == null) {
                configAuditTrail = new ArrayList<CallSite>();
            }
            configAuditTrail.add((CallSite)((Object)(new Date() + " " + userId + " added configuration for an Open Metadata Server Security Connector")));
            serverConfig.setAuditTrail(configAuditTrail);
            this.configStore.saveServerConfig(serverName, "setServerSecurityConnection", serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException("setServerSecurityConnection", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public synchronized ConnectionResponse getServerSecurityConnection(String userId, String serverName) {
        String methodName = "getServerSecurityConnection";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getServerSecurityConnection");
        ConnectionResponse response = new ConnectionResponse();
        try {
            this.errorHandler.validateServerName(serverName, "getServerSecurityConnection");
            this.errorHandler.validateUserId(userId, serverName, "getServerSecurityConnection");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, false, "getServerSecurityConnection");
            response.setConnection(serverConfig.getServerSecurityConnection());
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException("getServerSecurityConnection", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public synchronized VoidResponse clearServerSecurityConnection(String userId, String serverName) {
        String methodName = "clearServerSecurityConnection";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearServerSecurityConnection");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "clearServerSecurityConnection");
            this.errorHandler.validateUserId(userId, serverName, "clearServerSecurityConnection");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "clearServerSecurityConnection");
            serverConfig.setServerSecurityConnection(null);
            ArrayList<CallSite> configAuditTrail = serverConfig.getAuditTrail();
            if (configAuditTrail == null) {
                configAuditTrail = new ArrayList<CallSite>();
            }
            configAuditTrail.add((CallSite)((Object)(new Date().toString() + " " + userId + " removed configuration for an Open Metadata Server Security Connector")));
            serverConfig.setAuditTrail(configAuditTrail);
            this.configStore.saveServerConfig(serverName, "clearServerSecurityConnection", serverConfig);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException("clearServerSecurityConnection", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

