/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.server;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.adminservices.configuration.properties.IntegrationDaemonServicesConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.IntegrationGroupConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.IntegrationServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.CommonServicesDescription;
import org.odpi.openmetadata.adminservices.configuration.registration.ServerTypeClassification;
import org.odpi.openmetadata.adminservices.configuration.registration.ServiceOperationalStatus;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.adminservices.rest.IntegrationDaemonServicesResponse;
import org.odpi.openmetadata.adminservices.rest.IntegrationGroupsResponse;
import org.odpi.openmetadata.adminservices.rest.IntegrationServiceConfigResponse;
import org.odpi.openmetadata.adminservices.rest.IntegrationServiceRequestBody;
import org.odpi.openmetadata.adminservices.rest.IntegrationServicesResponse;
import org.odpi.openmetadata.adminservices.server.OMAGServerAdminStoreServices;
import org.odpi.openmetadata.adminservices.server.OMAGServerErrorHandler;
import org.odpi.openmetadata.adminservices.server.OMAGServerExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.RegisteredOMAGService;
import org.odpi.openmetadata.commonservices.ffdc.rest.RegisteredOMAGServicesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDevelopmentStatus;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.registration.IntegrationServiceRegistry;
import org.odpi.openmetadata.repositoryservices.admin.OMRSConfigurationFactory;
import org.slf4j.LoggerFactory;

public class OMAGServerAdminForIntegrationDaemonServices {
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(OMAGServerAdminForIntegrationDaemonServices.class), CommonServicesDescription.ADMINISTRATION_SERVICES.getServiceName());
    private final OMAGServerAdminStoreServices configStore = new OMAGServerAdminStoreServices();
    private final OMAGServerErrorHandler errorHandler = new OMAGServerErrorHandler();
    private final OMAGServerExceptionHandler exceptionHandler = new OMAGServerExceptionHandler();

    public IntegrationGroupsResponse getIntegrationGroupsConfiguration(String userId, String serverName) {
        String methodName = "getIntegrationGroupsConfiguration";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getIntegrationGroupsConfiguration");
        IntegrationGroupsResponse response = new IntegrationGroupsResponse();
        try {
            this.errorHandler.validateServerName(serverName, "getIntegrationGroupsConfiguration");
            this.errorHandler.validateUserId(userId, serverName, "getIntegrationGroupsConfiguration");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "getIntegrationGroupsConfiguration");
            response.setGroups(serverConfig.getDynamicIntegrationGroupsConfig());
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "getIntegrationGroupsConfiguration", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse configureIntegrationGroup(String userId, String serverName, IntegrationGroupConfig requestBody) {
        String methodName = "configureIntegrationGroup";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "configureIntegrationGroup");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "configureIntegrationGroup");
            this.errorHandler.validateUserId(userId, serverName, "configureIntegrationGroup");
            this.errorHandler.validateIntegrationGroupConfig(serverName, requestBody, "configureIntegrationGroup");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "configureIntegrationGroup");
            List integrationGroupsConfig = serverConfig.getDynamicIntegrationGroupsConfig();
            response = this.storeIntegrationGroupsConfig(userId, serverName, requestBody.getIntegrationGroupQualifiedName(), this.updateIntegrationGroupConfig(requestBody, integrationGroupsConfig), "configureIntegrationGroup");
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "configureIntegrationGroup", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private List<IntegrationGroupConfig> updateIntegrationGroupConfig(IntegrationGroupConfig integrationGroupConfig, List<IntegrationGroupConfig> currentList) {
        if (integrationGroupConfig == null) {
            return currentList;
        }
        ArrayList<IntegrationGroupConfig> newList = new ArrayList<IntegrationGroupConfig>();
        if (currentList != null) {
            for (IntegrationGroupConfig existingConfig : currentList) {
                if (existingConfig == null || existingConfig.getIntegrationGroupQualifiedName().equals(integrationGroupConfig.getIntegrationGroupQualifiedName())) continue;
                newList.add(existingConfig);
            }
        }
        newList.add(integrationGroupConfig);
        return newList;
    }

    public VoidResponse setIntegrationGroupsConfig(String userId, String serverName, List<IntegrationGroupConfig> integrationGroupsConfig) {
        String methodName = "setIntegrationGroupsConfig";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setIntegrationGroupsConfig");
        VoidResponse response = this.storeIntegrationGroupsConfig(userId, serverName, null, integrationGroupsConfig, "setIntegrationGroupsConfig");
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearAllIntegrationGroups(String userId, String serverName) {
        String methodName = "clearAllIntegrationGroups";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearAllIntegrationGroups");
        VoidResponse response = this.storeIntegrationGroupsConfig(userId, serverName, null, null, "clearAllIntegrationGroups");
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearIntegrationGroup(String userId, String serverName, String groupId) {
        String methodName = "clearIntegrationGroup";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearIntegrationGroup");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "clearIntegrationGroup");
            this.errorHandler.validateUserId(userId, serverName, "clearIntegrationGroup");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "clearIntegrationGroup");
            List currentList = serverConfig.getDynamicIntegrationGroupsConfig();
            ArrayList<IntegrationGroupConfig> newList = new ArrayList<IntegrationGroupConfig>();
            if (currentList != null) {
                for (IntegrationGroupConfig existingConfig : currentList) {
                    if (existingConfig == null || groupId.equals(existingConfig.getIntegrationGroupQualifiedName())) continue;
                    newList.add(existingConfig);
                }
                response = this.storeIntegrationGroupsConfig(userId, serverName, groupId, newList, "clearIntegrationGroup");
            }
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "clearIntegrationGroup", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private VoidResponse storeIntegrationGroupsConfig(String userId, String serverName, String groupQualifiedName, List<IntegrationGroupConfig> integrationGroupsConfig, String methodName) {
        VoidResponse response = new VoidResponse();
        try {
            ArrayList<CallSite> configAuditTrail;
            this.errorHandler.validateServerName(serverName, methodName);
            this.errorHandler.validateUserId(userId, serverName, methodName);
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, methodName);
            if (serverConfig.getRepositoryServicesConfig() == null) {
                OMRSConfigurationFactory omrsConfigurationFactory = new OMRSConfigurationFactory();
                serverConfig.setRepositoryServicesConfig(omrsConfigurationFactory.getDefaultRepositoryServicesConfig());
            }
            if ((configAuditTrail = serverConfig.getAuditTrail()) == null) {
                configAuditTrail = new ArrayList<CallSite>();
            }
            if (integrationGroupsConfig == null) {
                configAuditTrail.add((CallSite)((Object)(new Date() + " " + userId + " removed configuration for integration groups.")));
            } else if (groupQualifiedName == null) {
                configAuditTrail.add((CallSite)((Object)(new Date() + " " + userId + " updated configuration for integration groups.")));
            } else {
                configAuditTrail.add((CallSite)((Object)(new Date() + " " + userId + " updated configuration for integration group " + groupQualifiedName + ".")));
            }
            serverConfig.setAuditTrail(configAuditTrail);
            serverConfig.setDynamicIntegrationGroupsConfig(integrationGroupsConfig);
            this.configStore.saveServerConfig(serverName, methodName, serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, methodName, (FFDCResponseBase)response, error);
        }
        return response;
    }

    public RegisteredOMAGServicesResponse getRegisteredIntegrationServices(String userId, String serverName) {
        String methodName = "getRegisteredIntegrationServices";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getRegisteredIntegrationServices");
        RegisteredOMAGServicesResponse response = new RegisteredOMAGServicesResponse();
        try {
            this.errorHandler.validateServerName(serverName, "getRegisteredIntegrationServices");
            this.errorHandler.validateUserId(userId, serverName, "getRegisteredIntegrationServices");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "getRegisteredIntegrationServices");
            List integrationServiceConfigs = serverConfig.getIntegrationServicesConfig();
            if (integrationServiceConfigs != null && !integrationServiceConfigs.isEmpty()) {
                ArrayList<RegisteredOMAGService> services = new ArrayList<RegisteredOMAGService>();
                for (IntegrationServiceConfig integrationServiceConfig : integrationServiceConfigs) {
                    if (integrationServiceConfig == null) continue;
                    RegisteredOMAGService service = new RegisteredOMAGService();
                    service.setServiceId(integrationServiceConfig.getIntegrationServiceId());
                    service.setServiceName(integrationServiceConfig.getIntegrationServiceFullName());
                    service.setServiceDevelopmentStatus(integrationServiceConfig.getIntegrationServiceDevelopmentStatus());
                    service.setServiceDescription(integrationServiceConfig.getIntegrationServiceDescription());
                    service.setServiceURLMarker(integrationServiceConfig.getIntegrationServiceURLMarker());
                    service.setServiceWiki(integrationServiceConfig.getIntegrationServiceWiki());
                    service.setServerType(ServerTypeClassification.INTEGRATION_DAEMON.getServerTypeName());
                    service.setPartnerServiceName(integrationServiceConfig.getIntegrationServicePartnerOMAS());
                    service.setPartnerServerType(ServerTypeClassification.METADATA_ACCESS_SERVER.getServerTypeName());
                    services.add(service);
                }
                if (!services.isEmpty()) {
                    response.setServices(services);
                }
            }
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "getRegisteredIntegrationServices", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public IntegrationServicesResponse getIntegrationServicesConfiguration(String userId, String serverName) {
        String methodName = "getIntegrationServicesConfiguration";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getIntegrationServicesConfiguration");
        IntegrationServicesResponse response = new IntegrationServicesResponse();
        try {
            this.errorHandler.validateServerName(serverName, "getIntegrationServicesConfiguration");
            this.errorHandler.validateUserId(userId, serverName, "getIntegrationServicesConfiguration");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "getIntegrationServicesConfiguration");
            response.setServices(serverConfig.getIntegrationServicesConfig());
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "getIntegrationServicesConfiguration", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public IntegrationServiceConfigResponse getIntegrationServiceConfiguration(String userId, String serverName, String serviceURLMarker) {
        String methodName = "getIntegrationServiceConfiguration";
        String serviceURLMarkerParameterName = "serviceURLMarker";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getIntegrationServiceConfiguration");
        IntegrationServiceConfigResponse response = new IntegrationServiceConfigResponse();
        try {
            this.errorHandler.validateServerName(serverName, "getIntegrationServiceConfiguration");
            this.errorHandler.validateUserId(userId, serverName, "getIntegrationServiceConfiguration");
            this.errorHandler.validatePropertyNotNull(serviceURLMarker, "serviceURLMarker", serverName, "getIntegrationServiceConfiguration");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "getIntegrationServiceConfiguration");
            List currentList = serverConfig.getIntegrationServicesConfig();
            if (currentList != null) {
                for (IntegrationServiceConfig existingConfig : currentList) {
                    if (existingConfig == null || !serviceURLMarker.equals(existingConfig.getIntegrationServiceURLMarker())) continue;
                    response.setConfig(existingConfig);
                }
            }
            if (response.getConfig() == null) {
                response.setConfig(IntegrationServiceRegistry.getIntegrationServiceConfig((String)serviceURLMarker, (String)serverName, (String)"getIntegrationServiceConfiguration"));
            }
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "getIntegrationServiceConfiguration", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse configureIntegrationService(String userId, String serverName, String serviceURLMarker, IntegrationServiceRequestBody requestBody) {
        String methodName = "configureIntegrationService";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "configureIntegrationService");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "configureIntegrationService");
            this.errorHandler.validateUserId(userId, serverName, "configureIntegrationService");
            this.errorHandler.validateIntegrationServiceConfig(serverName, requestBody, "configureIntegrationService");
            IntegrationServiceConfig serviceConfig = IntegrationServiceRegistry.getIntegrationServiceConfig((String)serviceURLMarker, (String)serverName, (String)"configureIntegrationService");
            serviceConfig.setIntegrationServiceOperationalStatus(ServiceOperationalStatus.ENABLED);
            serviceConfig.setOMAGServerPlatformRootURL(requestBody.getOMAGServerPlatformRootURL());
            serviceConfig.setOMAGServerName(requestBody.getOMAGServerName());
            serviceConfig.setIntegrationConnectorConfigs(requestBody.getIntegrationConnectorConfigs());
            serviceConfig.setIntegrationServiceOptions(requestBody.getIntegrationServiceOptions());
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "configureIntegrationService");
            List integrationServiceConfigList = serverConfig.getIntegrationServicesConfig();
            response = this.storeIntegrationServicesConfig(userId, serverName, serviceURLMarker, this.updateIntegrationServiceConfig(serviceConfig, integrationServiceConfigList), "configureIntegrationService");
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "configureIntegrationService", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse configureAllIntegrationServices(String userId, String serverName, IntegrationServiceRequestBody requestBody) {
        String methodName = "configureAllIntegrationService";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "configureAllIntegrationService");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "configureAllIntegrationService");
            this.errorHandler.validateUserId(userId, serverName, "configureAllIntegrationService");
            this.errorHandler.validateIntegrationServiceConfig(serverName, requestBody, "configureAllIntegrationService");
            List registeredIntegrationServicesURLMarkers = IntegrationServiceRegistry.getRegisteredServiceURLMarkers();
            ArrayList<IntegrationServiceConfig> serviceConfigs = new ArrayList<IntegrationServiceConfig>();
            if (registeredIntegrationServicesURLMarkers != null) {
                for (String serviceURLMarker : registeredIntegrationServicesURLMarkers) {
                    IntegrationServiceConfig serviceConfig = IntegrationServiceRegistry.getIntegrationServiceConfig((String)serviceURLMarker, (String)serverName, (String)"configureAllIntegrationService");
                    if (serviceConfig.getIntegrationServiceDevelopmentStatus() == ComponentDevelopmentStatus.DEPRECATED) continue;
                    serviceConfig.setOMAGServerPlatformRootURL(requestBody.getOMAGServerPlatformRootURL());
                    serviceConfig.setOMAGServerName(requestBody.getOMAGServerName());
                    serviceConfig.setIntegrationConnectorConfigs(requestBody.getIntegrationConnectorConfigs());
                    serviceConfig.setIntegrationServiceOptions(requestBody.getIntegrationServiceOptions());
                    serviceConfigs.add(serviceConfig);
                }
            }
            response = this.storeIntegrationServicesConfig(userId, serverName, null, serviceConfigs, "configureAllIntegrationService");
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "configureAllIntegrationService", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse configureIntegrationService(String userId, String serverName, IntegrationServiceConfig serviceConfig) {
        String methodName = "configureIntegrationService";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "configureIntegrationService");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "configureIntegrationService");
            this.errorHandler.validateUserId(userId, serverName, "configureIntegrationService");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "configureIntegrationService");
            List integrationServiceConfigList = serverConfig.getIntegrationServicesConfig();
            response = this.storeIntegrationServicesConfig(userId, serverName, serviceConfig.getIntegrationServiceURLMarker(), this.updateIntegrationServiceConfig(serviceConfig, integrationServiceConfigList), "configureIntegrationService");
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "configureIntegrationService", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private List<IntegrationServiceConfig> updateIntegrationServiceConfig(IntegrationServiceConfig integrationServiceConfig, List<IntegrationServiceConfig> currentList) {
        if (integrationServiceConfig == null) {
            return currentList;
        }
        ArrayList<IntegrationServiceConfig> newList = new ArrayList<IntegrationServiceConfig>();
        if (currentList != null) {
            for (IntegrationServiceConfig existingConfig : currentList) {
                if (existingConfig == null || integrationServiceConfig.getIntegrationServiceId() == existingConfig.getIntegrationServiceId()) continue;
                newList.add(existingConfig);
            }
        }
        newList.add(integrationServiceConfig);
        return newList;
    }

    public VoidResponse setIntegrationServicesConfig(String userId, String serverName, List<IntegrationServiceConfig> integrationServicesConfig) {
        String methodName = "setIntegrationServicesConfig";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setIntegrationServicesConfig");
        VoidResponse response = this.storeIntegrationServicesConfig(userId, serverName, null, integrationServicesConfig, "setIntegrationServicesConfig");
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearAllIntegrationServices(String userId, String serverName) {
        String methodName = "clearAllIntegrationServices";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearAllIntegrationServices");
        VoidResponse response = this.storeIntegrationServicesConfig(userId, serverName, null, null, "clearAllIntegrationServices");
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearIntegrationService(String userId, String serverName, String serviceURLMarker) {
        String methodName = "clearIntegrationService";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearIntegrationService");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "clearIntegrationService");
            this.errorHandler.validateUserId(userId, serverName, "clearIntegrationService");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "clearIntegrationService");
            List currentList = serverConfig.getIntegrationServicesConfig();
            ArrayList<IntegrationServiceConfig> newList = new ArrayList<IntegrationServiceConfig>();
            if (currentList != null) {
                for (IntegrationServiceConfig existingConfig : currentList) {
                    if (existingConfig == null || serviceURLMarker.equals(existingConfig.getIntegrationServiceURLMarker())) continue;
                    newList.add(existingConfig);
                }
                response = this.storeIntegrationServicesConfig(userId, serverName, serviceURLMarker, newList, "clearIntegrationService");
            }
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "clearIntegrationService", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private VoidResponse storeIntegrationServicesConfig(String userId, String serverName, String serviceURLMarker, List<IntegrationServiceConfig> integrationServicesConfig, String methodName) {
        VoidResponse response = new VoidResponse();
        try {
            ArrayList<CallSite> configAuditTrail;
            this.errorHandler.validateServerName(serverName, methodName);
            this.errorHandler.validateUserId(userId, serverName, methodName);
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, methodName);
            if (serverConfig.getRepositoryServicesConfig() == null) {
                OMRSConfigurationFactory omrsConfigurationFactory = new OMRSConfigurationFactory();
                serverConfig.setRepositoryServicesConfig(omrsConfigurationFactory.getDefaultRepositoryServicesConfig());
            }
            if ((configAuditTrail = serverConfig.getAuditTrail()) == null) {
                configAuditTrail = new ArrayList<CallSite>();
            }
            if (integrationServicesConfig == null) {
                configAuditTrail.add((CallSite)((Object)(new Date() + " " + userId + " removed configuration for integration services.")));
            } else if (serviceURLMarker == null) {
                configAuditTrail.add((CallSite)((Object)(new Date() + " " + userId + " updated configuration for integration services.")));
            } else {
                configAuditTrail.add((CallSite)((Object)(new Date() + " " + userId + " updated configuration for integration service " + serviceURLMarker + ".")));
            }
            serverConfig.setAuditTrail(configAuditTrail);
            serverConfig.setIntegrationServicesConfig(integrationServicesConfig);
            this.configStore.saveServerConfig(serverName, methodName, serverConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, methodName, (FFDCResponseBase)response, error);
        }
        return response;
    }

    public IntegrationDaemonServicesResponse getIntegrationDaemonServicesConfiguration(String userId, String serverName) {
        String methodName = "getIntegrationDaemonServicesConfiguration";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getIntegrationDaemonServicesConfiguration");
        IntegrationDaemonServicesResponse response = new IntegrationDaemonServicesResponse();
        try {
            this.errorHandler.validateServerName(serverName, "getIntegrationDaemonServicesConfiguration");
            this.errorHandler.validateUserId(userId, serverName, "getIntegrationDaemonServicesConfiguration");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "getIntegrationDaemonServicesConfiguration");
            IntegrationDaemonServicesConfig integrationDaemonServicesConfig = new IntegrationDaemonServicesConfig();
            integrationDaemonServicesConfig.setDynamicIntegrationGroupsConfig(serverConfig.getDynamicIntegrationGroupsConfig());
            integrationDaemonServicesConfig.setIntegrationServicesConfig(serverConfig.getIntegrationServicesConfig());
            response.setServices(integrationDaemonServicesConfig);
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "getIntegrationDaemonServicesConfiguration", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setIntegrationDaemonServicesConfig(String userId, String serverName, IntegrationDaemonServicesConfig servicesConfig) {
        String methodName = "setIntegrationDaemonServicesConfig";
        String serviceConfigParameterName = "servicesConfig";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setIntegrationDaemonServicesConfig");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setIntegrationDaemonServicesConfig");
            this.errorHandler.validateUserId(userId, serverName, "setIntegrationDaemonServicesConfig");
            this.errorHandler.validatePropertyNotNull(servicesConfig, "servicesConfig", serverName, "setIntegrationDaemonServicesConfig");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "setIntegrationDaemonServicesConfig");
            if (serverConfig != null) {
                serverConfig.setDynamicIntegrationGroupsConfig(servicesConfig.getDynamicIntegrationGroupsConfig());
                serverConfig.setIntegrationServicesConfig(servicesConfig.getIntegrationServicesConfig());
                this.configStore.saveServerConfig(serverName, "setIntegrationDaemonServicesConfig", serverConfig);
            }
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "setIntegrationDaemonServicesConfig", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearIntegrationDaemonServicesConfig(String userId, String serverName) {
        String methodName = "clearIntegrationDaemonServicesConfig";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearIntegrationDaemonServicesConfig");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "clearIntegrationDaemonServicesConfig");
            this.errorHandler.validateUserId(userId, serverName, "clearIntegrationDaemonServicesConfig");
            OMAGServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "clearIntegrationDaemonServicesConfig");
            if (serverConfig != null) {
                serverConfig.setDynamicIntegrationGroupsConfig(null);
                serverConfig.setIntegrationServicesConfig(null);
                this.configStore.saveServerConfig(serverName, "clearIntegrationDaemonServicesConfig", serverConfig);
            }
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException(serverName, "clearIntegrationDaemonServicesConfig", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

