/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.server;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import org.odpi.openmetadata.adapters.repositoryservices.ConnectorConfigurationFactory;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.CommonServicesDescription;
import org.odpi.openmetadata.adminservices.ffdc.OMAGAdminErrorCode;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.adminservices.rest.ConnectionResponse;
import org.odpi.openmetadata.adminservices.rest.OMAGServerConfigResponse;
import org.odpi.openmetadata.adminservices.server.OMAGServerErrorHandler;
import org.odpi.openmetadata.adminservices.server.OMAGServerExceptionHandler;
import org.odpi.openmetadata.adminservices.store.OMAGServerConfigStore;
import org.odpi.openmetadata.adminservices.store.OMAGServerConfigStoreRetrieveAll;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.StringMapResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBroker;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataPlatformSecurityVerifier;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.slf4j.LoggerFactory;

public class OMAGServerAdminStoreServices {
    private static Connection configurationStoreConnection = null;
    private static OMAGServerConfig defaultServerConfig = new OMAGServerConfig();
    private static Map<String, String> placeHolderVariables = null;
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(OMAGServerAdminStoreServices.class), CommonServicesDescription.ADMINISTRATION_SERVICES.getServiceName());
    private final OMAGServerExceptionHandler exceptionHandler = new OMAGServerExceptionHandler();
    private final OMAGServerErrorHandler errorHandler = new OMAGServerErrorHandler();
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public synchronized VoidResponse setDefaultOMAGServerConfig(String userId, OMAGServerConfig defaultServerConfig) {
        String methodName = "setDefaultOMAGServerConfig";
        String parameterName = "defaultServerConfig";
        RESTCallToken token = restCallLogger.logRESTCall(null, userId, "setDefaultOMAGServerConfig");
        VoidResponse response = new VoidResponse();
        try {
            OpenMetadataPlatformSecurityVerifier.validateUserAsOperatorForPlatform((String)userId);
            this.errorHandler.validatePropertyNotNull(defaultServerConfig, "defaultServerConfig", null, "setDefaultOMAGServerConfig");
            OMAGServerAdminStoreServices.defaultServerConfig = defaultServerConfig;
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException("setDefaultOMAGServerConfig", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public synchronized OMAGServerConfigResponse getDefaultOMAGServerConfig(String userId) {
        String methodName = "getDefaultOMAGServerConfig";
        RESTCallToken token = restCallLogger.logRESTCall(null, userId, "getDefaultOMAGServerConfig");
        OMAGServerConfigResponse response = new OMAGServerConfigResponse();
        try {
            OpenMetadataPlatformSecurityVerifier.validateUserAsOperatorForPlatform((String)userId);
            response.setOMAGServerConfig(defaultServerConfig);
        }
        catch (UserNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException("getDefaultOMAGServerConfig", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public synchronized VoidResponse clearDefaultOMAGServerConfig(String userId) {
        String methodName = "clearDefaultServerConfig";
        RESTCallToken token = restCallLogger.logRESTCall(null, userId, "clearDefaultServerConfig");
        VoidResponse response = new VoidResponse();
        try {
            OpenMetadataPlatformSecurityVerifier.validateUserAsOperatorForPlatform((String)userId);
            defaultServerConfig = new OMAGServerConfig();
        }
        catch (UserNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException("clearDefaultServerConfig", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private synchronized OMAGServerConfig getDefaultServerConfig() {
        return defaultServerConfig;
    }

    public synchronized VoidResponse setPlaceholderVariables(String userId, Map<String, String> placeholderVariables) {
        String methodName = "setPlaceholderVariables";
        String parameterName = "placeholderVariables";
        RESTCallToken token = restCallLogger.logRESTCall(null, userId, "setPlaceholderVariables");
        VoidResponse response = new VoidResponse();
        try {
            OpenMetadataPlatformSecurityVerifier.validateUserAsOperatorForPlatform((String)userId);
            this.errorHandler.validatePropertyNotNull(placeholderVariables, "placeholderVariables", null, "setPlaceholderVariables");
            placeHolderVariables = placeholderVariables;
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException("setPlaceholderVariables", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public synchronized StringMapResponse getPlaceholderVariables(String userId) {
        String methodName = "getPlaceholderVariables";
        RESTCallToken token = restCallLogger.logRESTCall(null, userId, "getPlaceholderVariables");
        StringMapResponse response = new StringMapResponse();
        try {
            OpenMetadataPlatformSecurityVerifier.validateUserAsOperatorForPlatform((String)userId);
            response.setStringMap(placeHolderVariables);
        }
        catch (UserNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException("getPlaceholderVariables", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public synchronized VoidResponse clearPlaceholderVariables(String userId) {
        String methodName = "clearPlaceholderVariables";
        RESTCallToken token = restCallLogger.logRESTCall(null, userId, "clearPlaceholderVariables");
        VoidResponse response = new VoidResponse();
        try {
            OpenMetadataPlatformSecurityVerifier.validateUserAsOperatorForPlatform((String)userId);
            placeHolderVariables = null;
        }
        catch (UserNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException("clearPlaceholderVariables", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private synchronized Map<String, String> getPlaceholderVariables() {
        return placeHolderVariables;
    }

    public synchronized VoidResponse setConfigurationStoreConnection(String userId, Connection connection) {
        String methodName = "setConfigurationStoreConnection";
        RESTCallToken token = restCallLogger.logRESTCall(null, userId, "setConfigurationStoreConnection");
        VoidResponse response = new VoidResponse();
        try {
            OpenMetadataPlatformSecurityVerifier.validateUserAsOperatorForPlatform((String)userId);
            this.errorHandler.validatePlatformConnection(connection, "setConfigurationStoreConnection");
            configurationStoreConnection = connection;
        }
        catch (OMAGInvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException("setConfigurationStoreConnection", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public synchronized ConnectionResponse getConfigurationStoreConnection(String userId) {
        String methodName = "getConfigurationStoreConnection";
        RESTCallToken token = restCallLogger.logRESTCall(null, userId, "getConfigurationStoreConnection");
        ConnectionResponse response = new ConnectionResponse();
        try {
            OpenMetadataPlatformSecurityVerifier.validateUserAsOperatorForPlatform((String)userId);
            response.setConnection(configurationStoreConnection);
        }
        catch (UserNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException("getConfigurationStoreConnection", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public synchronized VoidResponse clearConfigurationStoreConnection(String userId) {
        String methodName = "clearConfigurationStoreConnection";
        RESTCallToken token = restCallLogger.logRESTCall(null, userId, "clearConfigurationStoreConnection");
        VoidResponse response = new VoidResponse();
        try {
            OpenMetadataPlatformSecurityVerifier.validateUserAsOperatorForPlatform((String)userId);
            configurationStoreConnection = null;
        }
        catch (UserNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException("clearConfigurationStoreConnection", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private synchronized Connection getConnection(String serverName) {
        if (configurationStoreConnection == null) {
            ConnectorConfigurationFactory connectorConfigurationFactory = new ConnectorConfigurationFactory();
            return connectorConfigurationFactory.getServerConfigConnection(serverName);
        }
        return configurationStoreConnection;
    }

    private synchronized Connection getConnectionForRetrieveAll() {
        if (configurationStoreConnection == null) {
            ConnectorConfigurationFactory connectorConfigurationFactory = new ConnectorConfigurationFactory();
            return connectorConfigurationFactory.getServerConfigConnectionForRetrieveAll();
        }
        return configurationStoreConnection;
    }

    private OMAGServerConfigStore getServerConfigStore(String serverName, String methodName) throws OMAGInvalidParameterException {
        Connection connection = this.getConnection(serverName);
        try {
            ConnectorBroker connectorBroker = new ConnectorBroker();
            Connector connector = connectorBroker.getConnector(connection);
            OMAGServerConfigStore serverConfigStore = (OMAGServerConfigStore)connector;
            serverConfigStore.setServerName(serverName);
            connector.start();
            return serverConfigStore;
        }
        catch (Exception error) {
            throw new OMAGInvalidParameterException(OMAGAdminErrorCode.BAD_CONFIG_FILE.getMessageDefinition(new String[]{serverName, methodName, error.getClass().getName(), error.getMessage()}), this.getClass().getName(), methodName, (Throwable)error);
        }
    }

    private OMAGServerConfigStoreRetrieveAll getServerConfigStoreForRetrieveAll() throws OMAGConfigurationErrorException {
        String methodName = "getServerConfigStoreForRetrieveAll";
        Connection connection = this.getConnectionForRetrieveAll();
        try {
            ConnectorBroker connectorBroker = new ConnectorBroker();
            Connector connector = connectorBroker.getConnector(connection);
            OMAGServerConfigStore serverConfigStore = (OMAGServerConfigStore)connector;
            connector.start();
            return this.getOMAGServerConfigStoreRetrieveAll(serverConfigStore, "getServerConfigStoreForRetrieveAll");
        }
        catch (Exception error) {
            throw new OMAGConfigurationErrorException(OMAGAdminErrorCode.UNABLE_TO_OBTAIN_SERVER_CONFIG_STORE.getMessageDefinition(new String[]{"getServerConfigStoreForRetrieveAll", error.getClass().getName(), error.getMessage()}), this.getClass().getName(), "getServerConfigStoreForRetrieveAll", (Throwable)error);
        }
    }

    OMAGServerConfigStoreRetrieveAll getOMAGServerConfigStoreRetrieveAll(OMAGServerConfigStore serverConfigStore, String methodName) throws OMAGConfigurationErrorException {
        if (!(serverConfigStore instanceof OMAGServerConfigStoreRetrieveAll)) {
            throw new OMAGConfigurationErrorException(OMAGAdminErrorCode.RETRIEVE_ALL_CONFIGS_NOT_SUPPORTED.getMessageDefinition(), this.getClass().getName(), methodName);
        }
        OMAGServerConfigStoreRetrieveAll omagServerConfigStoreRetrieveAll = (OMAGServerConfigStoreRetrieveAll)serverConfigStore;
        return omagServerConfigStoreRetrieveAll;
    }

    OMAGServerConfig getServerConfig(String userId, String serverName, String methodName) throws OMAGInvalidParameterException, OMAGNotAuthorizedException, OMAGConfigurationErrorException {
        return this.getServerConfig(userId, serverName, true, methodName);
    }

    public OMAGServerConfig getServerConfig(String userId, String serverName, boolean adminCall, String methodName) throws OMAGInvalidParameterException, OMAGNotAuthorizedException, OMAGConfigurationErrorException {
        OMAGServerConfigStore serverConfigStore = this.getServerConfigStore(serverName, methodName);
        OMAGServerConfig serverConfig = null;
        if (serverConfigStore != null) {
            serverConfig = serverConfigStore.retrieveServerConfig();
        }
        if (serverConfig == null) {
            try {
                OpenMetadataPlatformSecurityVerifier.validateUserForNewServer((String)userId);
            }
            catch (UserNotAuthorizedException error) {
                throw new OMAGNotAuthorizedException(error.getReportedErrorMessage(), (OCFCheckedExceptionBase)error);
            }
            serverConfig = new OMAGServerConfig(this.getDefaultServerConfig());
            serverConfig.setVersionId("V2.0");
            serverConfig.setLocalServerType(OMAGServerConfig.defaultLocalServerType);
            serverConfig.setLocalServerId(UUID.randomUUID().toString());
        } else {
            String versionId = serverConfig.getVersionId();
            boolean isCompatibleVersion = false;
            if (versionId == null) {
                versionId = "V1.0";
            }
            for (String compatibleVersion : OMAGServerConfig.COMPATIBLE_VERSIONS) {
                if (!compatibleVersion.equals(versionId)) continue;
                isCompatibleVersion = true;
                break;
            }
            if (!isCompatibleVersion) {
                throw new OMAGInvalidParameterException(OMAGAdminErrorCode.INCOMPATIBLE_CONFIG_FILE.getMessageDefinition(new String[]{serverName, versionId, OMAGServerConfig.COMPATIBLE_VERSIONS.toString()}), this.getClass().getName(), methodName);
            }
            OMAGServerConfig resolvedServerConfig = this.resolvePlaceholdersInConfig(serverConfig);
            try {
                OpenMetadataServerSecurityVerifier securityVerifier = new OpenMetadataServerSecurityVerifier();
                securityVerifier.registerSecurityValidator(resolvedServerConfig.getLocalServerUserId(), serverName, null, resolvedServerConfig.getServerSecurityConnection());
                if (adminCall) {
                    securityVerifier.validateUserAsServerAdmin(userId);
                } else {
                    securityVerifier.validateUserAsServerOperator(userId);
                }
            }
            catch (InvalidParameterException error) {
                throw new OMAGInvalidParameterException(error.getReportedErrorMessage(), (OCFCheckedExceptionBase)error);
            }
            catch (UserNotAuthorizedException error) {
                throw new OMAGNotAuthorizedException(error.getReportedErrorMessage(), (OCFCheckedExceptionBase)error);
            }
        }
        serverConfig.setLocalServerName(serverName);
        return serverConfig;
    }

    public OMAGServerConfig getServerConfigForStartUp(String userId, String serverName, String methodName) throws OMAGInvalidParameterException, OMAGNotAuthorizedException, OMAGConfigurationErrorException {
        OMAGServerConfigStore serverConfigStore = this.getServerConfigStore(serverName, methodName);
        OMAGServerConfig serverConfig = null;
        if (serverConfigStore != null) {
            serverConfig = serverConfigStore.retrieveServerConfig();
        }
        if (serverConfig == null) {
            throw new OMAGInvalidParameterException(OMAGAdminErrorCode.NO_CONFIG_DOCUMENT.getMessageDefinition(new String[]{serverName}), this.getClass().getName(), methodName);
        }
        String versionId = serverConfig.getVersionId();
        boolean isCompatibleVersion = false;
        if (versionId == null) {
            versionId = "V1.0";
        }
        for (String compatibleVersion : OMAGServerConfig.COMPATIBLE_VERSIONS) {
            if (!compatibleVersion.equals(versionId)) continue;
            isCompatibleVersion = true;
            break;
        }
        if (!isCompatibleVersion) {
            throw new OMAGInvalidParameterException(OMAGAdminErrorCode.INCOMPATIBLE_CONFIG_FILE.getMessageDefinition(new String[]{serverName, versionId, OMAGServerConfig.COMPATIBLE_VERSIONS.toString()}), this.getClass().getName(), methodName);
        }
        serverConfig = this.resolvePlaceholdersInConfig(serverConfig);
        this.validateConfigServerName(serverName, serverConfig.getLocalServerName(), methodName);
        try {
            OpenMetadataServerSecurityVerifier securityVerifier = new OpenMetadataServerSecurityVerifier();
            securityVerifier.registerSecurityValidator(serverConfig.getLocalServerUserId(), serverName, null, serverConfig.getServerSecurityConnection());
            securityVerifier.validateUserAsServerOperator(userId);
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error.getReportedErrorMessage(), (OCFCheckedExceptionBase)error);
        }
        catch (UserNotAuthorizedException error) {
            throw new OMAGNotAuthorizedException(error.getReportedErrorMessage(), (OCFCheckedExceptionBase)error);
        }
        serverConfig.setLocalServerName(serverName);
        return serverConfig;
    }

    private OMAGServerConfig resolvePlaceholdersInConfig(OMAGServerConfig retrievedServerConfig) throws OMAGConfigurationErrorException {
        String methodName = "resolvePlaceholdersInConfig";
        Map<String, String> currentPlaceholderValues = this.getPlaceholderVariables();
        if (currentPlaceholderValues != null && !currentPlaceholderValues.isEmpty()) {
            try {
                String omagServerConfigString = OBJECT_MAPPER.writeValueAsString((Object)retrievedServerConfig);
                for (String variableName : currentPlaceholderValues.keySet()) {
                    String regExMatchString = Pattern.quote("~{" + variableName + "}~");
                    String[] configBits = omagServerConfigString.split(regExMatchString);
                    if (configBits.length <= 1) continue;
                    StringBuilder newConfigString = new StringBuilder();
                    boolean firstPart = true;
                    for (String configBit : configBits) {
                        if (!firstPart) {
                            newConfigString.append(currentPlaceholderValues.get(variableName));
                        }
                        firstPart = false;
                        if (configBit == null) continue;
                        newConfigString.append(configBit);
                    }
                    omagServerConfigString = newConfigString.toString();
                }
                return (OMAGServerConfig)OBJECT_MAPPER.readValue(omagServerConfigString, OMAGServerConfig.class);
            }
            catch (JsonProcessingException parsingError) {
                throw new OMAGConfigurationErrorException(OMAGAdminErrorCode.CONFIG_DOCUMENT_PARSE_ERROR.getMessageDefinition(new String[]{retrievedServerConfig.getLocalServerName(), ((Object)((Object)parsingError)).getClass().getName(), parsingError.getMessage()}), this.getClass().getName(), "resolvePlaceholdersInConfig");
            }
        }
        return retrievedServerConfig;
    }

    public void saveServerConfig(String serverName, String methodName, OMAGServerConfig serverConfig) throws OMAGInvalidParameterException {
        OMAGServerConfigStore serverConfigStore = this.getServerConfigStore(serverName, methodName);
        if (serverConfigStore != null) {
            if (serverConfig != null) {
                this.validateConfigServerName(serverName, serverConfig.getLocalServerName(), methodName);
                serverConfigStore.saveServerConfig(serverConfig);
            } else {
                serverConfigStore.removeServerConfig();
            }
        }
    }

    Set<OMAGServerConfig> retrieveAllServerConfigs(String userId) throws OMAGConfigurationErrorException {
        String methodName = "retrieveAllServerConfigs";
        OMAGServerConfigStoreRetrieveAll serverConfigStore = this.getServerConfigStoreForRetrieveAll();
        Set configuredServers = serverConfigStore.retrieveAllServerConfigs();
        if (configuredServers != null) {
            HashSet<OMAGServerConfig> validatedServers = new HashSet<OMAGServerConfig>();
            for (OMAGServerConfig serverConfig : configuredServers) {
                if (serverConfig == null) continue;
                try {
                    OMAGServerConfig validatedConfig = this.getServerConfig(userId, serverConfig.getLocalServerName(), false, "retrieveAllServerConfigs");
                    if (validatedConfig == null) continue;
                    validatedServers.add(validatedConfig);
                }
                catch (Exception exception) {}
            }
            return validatedServers;
        }
        return null;
    }

    private void validateConfigServerName(String serverName, String configServerName, String methodName) throws OMAGInvalidParameterException {
        if (!serverName.equals(configServerName)) {
            throw new OMAGInvalidParameterException(OMAGAdminErrorCode.INCOMPATIBLE_SERVER_NAMES.getMessageDefinition(new String[]{serverName, configServerName}), this.getClass().getName(), methodName);
        }
    }
}

