/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.spring;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adminservices.OMAGServerAdminServices;
import org.odpi.openmetadata.adminservices.configuration.properties.CohortConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.LocalRepositoryConfig;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/open-metadata/admin-services/users/{userId}/servers/{serverName}"})
public class ConfigRepositoryServicesResource {
    private OMAGServerAdminServices adminAPI = new OMAGServerAdminServices();

    @RequestMapping(method={RequestMethod.POST}, path={"/audit-log-destinations/default"})
    public VoidResponse setDefaultAuditLog(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.setDefaultAuditLog(userId, serverName);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/open-metadata-archives/file"})
    public VoidResponse addStartUpOpenMetadataArchiveFile(@PathVariable String userId, @PathVariable String serverName, @RequestBody String fileName) {
        return this.adminAPI.addStartUpOpenMetadataArchiveFile(userId, serverName, fileName);
    }

    @RequestMapping(method={RequestMethod.DELETE}, path={"/local-repository"})
    public VoidResponse setNoRepositoryMode(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.setNoRepositoryMode(userId, serverName);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/local-repository/mode/in-memory-repository"})
    public VoidResponse setInMemLocalRepository(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.setInMemLocalRepository(userId, serverName);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/local-repository/mode/local-graph-repository"})
    public VoidResponse setGraphLocalRepository(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.setGraphLocalRepository(userId, serverName);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/local-repository/mode/repository-proxy/connection"})
    public VoidResponse setRepositoryProxyConnection(@PathVariable String userId, @PathVariable String serverName, @RequestBody Connection connection) {
        return this.adminAPI.setRepositoryProxyConnection(userId, serverName, connection);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/local-repository/mode/repository-proxy/details"})
    public VoidResponse setRepositoryProxyConnection(@PathVariable String userId, @PathVariable String serverName, @RequestParam String connectorProvider, @RequestBody(required=false) Map<String, Object> additionalProperties) {
        return this.adminAPI.setRepositoryProxyConnection(userId, serverName, connectorProvider, additionalProperties);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/local-repository/event-mapper-connection"})
    public VoidResponse setLocalRepositoryEventMapper(@PathVariable String userId, @PathVariable String serverName, @RequestBody Connection connection) {
        return this.adminAPI.setLocalRepositoryEventMapper(userId, serverName, connection);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/local-repository/event-mapper-details"})
    public VoidResponse setLocalRepositoryEventMapper(@PathVariable String userId, @PathVariable String serverName, @RequestParam String connectorProvider, @RequestParam String eventSource, @RequestBody(required=false) Map<String, Object> additionalProperties) {
        return this.adminAPI.setLocalRepositoryEventMapper(userId, serverName, connectorProvider, eventSource, additionalProperties);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/local-repository/metadata-collection-name/{name}"})
    public VoidResponse setLocalMetadataCollectionName(@PathVariable String userId, @PathVariable String serverName, @PathVariable String name) {
        return this.adminAPI.setLocalMetadataCollectionName(userId, serverName, name);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/local-repository/metadata-collection-id"})
    public GUIDResponse getLocalMetadataCollectionId(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.getLocalMetadataCollectionId(userId, serverName);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/cohorts/{cohortName}"})
    public VoidResponse enableCohortRegistration(@PathVariable String userId, @PathVariable String serverName, @PathVariable String cohortName, @RequestBody(required=false) Map<String, Object> additionalProperties) {
        return this.adminAPI.enableCohortRegistration(userId, serverName, cohortName, additionalProperties);
    }

    @RequestMapping(method={RequestMethod.DELETE}, path={"/cohorts/{cohortName}"})
    public VoidResponse disableCohortRegistration(@PathVariable String userId, @PathVariable String serverName, @PathVariable String cohortName) {
        return this.adminAPI.disableCohortRegistration(userId, serverName, cohortName);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/audit-log-destinations"})
    public VoidResponse setAuditLogDestinations(@PathVariable String userId, @PathVariable String serverName, @RequestBody List<Connection> auditLogDestinations) {
        return this.adminAPI.setAuditLogDestinations(userId, serverName, auditLogDestinations);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/open-metadata-archives"})
    public VoidResponse setOpenMetadataArchives(@PathVariable String userId, @PathVariable String serverName, @RequestBody List<Connection> openMetadataArchives) {
        return this.adminAPI.setOpenMetadataArchives(userId, serverName, openMetadataArchives);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/local-repository/configuration"})
    public VoidResponse setLocalRepositoryConfig(@PathVariable String userId, @PathVariable String serverName, @RequestBody LocalRepositoryConfig localRepositoryConfig) {
        return this.adminAPI.setLocalRepositoryConfig(userId, serverName, localRepositoryConfig);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/cohorts/{cohortName}/configuration"})
    public VoidResponse setCohortConfig(@PathVariable String userId, @PathVariable String serverName, @PathVariable String cohortName, @RequestBody CohortConfig cohortConfig) {
        return this.adminAPI.setCohortConfig(userId, serverName, cohortName, cohortConfig);
    }
}

