/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.spring;

import org.odpi.openmetadata.adminservices.OMAGServerOperationalServices;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.rest.OMAGServerConfigResponse;
import org.odpi.openmetadata.adminservices.rest.SuccessMessageResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/open-metadata/admin-services/users/{userId}/servers/{serverName}"})
public class OperationalServicesResource {
    private OMAGServerOperationalServices operationalServices = new OMAGServerOperationalServices();

    @RequestMapping(method={RequestMethod.POST}, path={"/instance"})
    public SuccessMessageResponse activateWithStoredConfig(@PathVariable String userId, @PathVariable String serverName) {
        return this.operationalServices.activateWithStoredConfig(userId, serverName);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/instance/configuration"})
    public SuccessMessageResponse activateWithSuppliedConfig(@PathVariable String userId, @PathVariable String serverName, @RequestBody OMAGServerConfig configuration) {
        return this.operationalServices.activateWithSuppliedConfig(userId, serverName, configuration);
    }

    @RequestMapping(method={RequestMethod.DELETE}, path={"/instance"})
    public VoidResponse deactivateTemporarily(@PathVariable String userId, @PathVariable String serverName) {
        return this.operationalServices.deactivateTemporarily(userId, serverName);
    }

    @RequestMapping(method={RequestMethod.DELETE}, path={""})
    public VoidResponse deactivatePermanently(@PathVariable String userId, @PathVariable String serverName) {
        return this.operationalServices.deactivatePermanently(userId, serverName);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/instance/configuration"})
    public OMAGServerConfigResponse getActiveConfiguration(@PathVariable String userId, @PathVariable String serverName) {
        return this.operationalServices.getActiveConfiguration(userId, serverName);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/instance/open-metadata-archives/file"})
    public VoidResponse addOpenMetadataArchiveFile(@PathVariable String userId, @PathVariable String serverName, @RequestBody String fileName) {
        return this.operationalServices.addOpenMetadataArchiveFile(userId, serverName, fileName);
    }
}

