/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.spring;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adminservices.OMAGServerAdminForAccessServices;
import org.odpi.openmetadata.adminservices.configuration.properties.AccessServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.EnterpriseAccessConfig;
import org.odpi.openmetadata.commonservices.ffdc.rest.RegisteredOMAGServicesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/open-metadata/admin-services/users/{userId}/servers/{serverName}"})
public class ConfigAccessServicesResource {
    private OMAGServerAdminForAccessServices adminAPI = new OMAGServerAdminForAccessServices();

    @GetMapping(path={"/access-services/configuration"})
    public RegisteredOMAGServicesResponse getConfiguredAccessServices(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.getConfiguredAccessServices(userId, serverName);
    }

    @PostMapping(path={"/access-services/{serviceURLMarker}"})
    public VoidResponse configureAccessService(@PathVariable String userId, @PathVariable String serverName, @PathVariable String serviceURLMarker, @RequestBody(required=false) Map<String, Object> accessServiceOptions) {
        return this.adminAPI.configureAccessService(userId, serverName, serviceURLMarker, accessServiceOptions);
    }

    @PostMapping(path={"/access-services"})
    public VoidResponse enableAccessServices(@PathVariable String userId, @PathVariable String serverName, @RequestBody(required=false) Map<String, Object> accessServiceOptions) {
        return this.adminAPI.enableAccessServices(userId, serverName, accessServiceOptions);
    }

    @DeleteMapping(path={"/access-services"})
    public VoidResponse disableAccessServices(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.disableAccessServices(userId, serverName);
    }

    @PostMapping(path={"/access-services/configuration"})
    public VoidResponse setAccessServicesConfig(@PathVariable String userId, @PathVariable String serverName, @RequestBody List<AccessServiceConfig> accessServicesConfig) {
        return this.adminAPI.setAccessServicesConfig(userId, serverName, accessServicesConfig);
    }

    @PostMapping(path={"/enterprise-access/configuration"})
    public VoidResponse setEnterpriseAccessConfig(@PathVariable String userId, @PathVariable String serverName, @RequestBody EnterpriseAccessConfig enterpriseAccessConfig) {
        return this.adminAPI.setEnterpriseAccessConfig(userId, serverName, enterpriseAccessConfig);
    }
}

