/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.spring;

import org.odpi.openmetadata.adminservices.OMAGServerAdminServices;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.rest.OMAGServerConfigResponse;
import org.odpi.openmetadata.adminservices.rest.URLRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/open-metadata/admin-services/users/{userId}/servers/{serverName}"})
public class ConfigResource {
    private OMAGServerAdminServices adminAPI = new OMAGServerAdminServices();

    @GetMapping(path={"/configuration"})
    public OMAGServerConfigResponse getCurrentConfiguration(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.getStoredConfiguration(userId, serverName);
    }

    @PostMapping(path={"/configuration"})
    public VoidResponse setOMAGServerConfig(@PathVariable String userId, @PathVariable String serverName, @RequestBody OMAGServerConfig omagServerConfig) {
        return this.adminAPI.setOMAGServerConfig(userId, serverName, omagServerConfig);
    }

    @PostMapping(path={"/configuration/deploy"})
    public VoidResponse deployOMAGServerConfig(@PathVariable String userId, @PathVariable String serverName, @RequestBody URLRequestBody destinationPlatform) {
        return this.adminAPI.deployOMAGServerConfig(userId, serverName, destinationPlatform);
    }
}

