/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.spring;

import java.util.List;
import org.odpi.openmetadata.adminservices.OMAGServerConfigDiscoveryEngineServices;
import org.odpi.openmetadata.adminservices.configuration.properties.DiscoveryEngineServicesConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerClientConfig;
import org.odpi.openmetadata.adminservices.rest.DiscoveryEngineServicesConfigResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/open-metadata/admin-services/users/{userId}/servers/{serverName}/discovery-engine-services"})
public class ConfigDiscoveryEngineServicesResource {
    private OMAGServerConfigDiscoveryEngineServices adminAPI = new OMAGServerConfigDiscoveryEngineServices();

    @PostMapping(path={"/client-config"})
    public VoidResponse setClientConfig(@PathVariable String userId, @PathVariable String serverName, @RequestBody OMAGServerClientConfig clientConfig) {
        return this.adminAPI.setClientConfig(userId, serverName, clientConfig);
    }

    @PostMapping(path={"/discovery-engines"})
    public VoidResponse setDiscoveryEngines(@PathVariable String userId, @PathVariable String serverName, @RequestBody List<String> discoveryEngines) {
        return this.adminAPI.setDiscoveryEngines(userId, serverName, discoveryEngines);
    }

    @PostMapping(path={""})
    public VoidResponse setDiscoveryEngineServicesConfig(@PathVariable String userId, @PathVariable String serverName, @RequestBody DiscoveryEngineServicesConfig servicesConfig) {
        return this.adminAPI.setDiscoveryEngineServicesConfig(userId, serverName, servicesConfig);
    }

    @GetMapping(path={""})
    public DiscoveryEngineServicesConfigResponse getDiscoveryEngineServicesConfig(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.getDiscoveryEngineServicesConfig(userId, serverName);
    }

    @DeleteMapping(path={""})
    public VoidResponse clearDiscoveryEngineServicesConfig(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.clearDiscoveryEngineServicesConfig(userId, serverName);
    }
}

