/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.spring;

import org.odpi.openmetadata.adminservices.OMAGServerAdminSecurityServices;
import org.odpi.openmetadata.adminservices.rest.ConnectionResponse;
import org.odpi.openmetadata.adminservices.rest.PlatformSecurityRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/open-metadata/admin-services/users/{userId}"})
public class ConfigOpenMetadataSecurityResource {
    private static OMAGServerAdminSecurityServices adminSecurityAPI = new OMAGServerAdminSecurityServices();

    @PostMapping(path={"/platform/security/connection"})
    public VoidResponse setPlatformSecurityConnection(@PathVariable String userId, @RequestBody PlatformSecurityRequestBody requestBody) {
        return adminSecurityAPI.setPlatformSecurityConnection(userId, requestBody);
    }

    @GetMapping(path={"/platform/security/connection"})
    public ConnectionResponse getPlatformSecurityConnection(@PathVariable String userId) {
        return adminSecurityAPI.getPlatformSecurityConnection(userId);
    }

    @DeleteMapping(path={"/platform/security/connection"})
    public VoidResponse clearPlatformSecurityConnection(@PathVariable String userId) {
        return adminSecurityAPI.clearPlatformSecurityConnection(userId);
    }

    @PostMapping(path={"/servers/{serverName}/security/connection"})
    public synchronized VoidResponse setServerSecurityConnection(@PathVariable String userId, @PathVariable String serverName, @RequestBody Connection connection) {
        return adminSecurityAPI.setServerSecurityConnection(userId, serverName, connection);
    }

    @GetMapping(path={"/servers/{serverName}/security/connection"})
    public synchronized ConnectionResponse getServerSecurityConnection(@PathVariable String userId, @PathVariable String serverName) {
        return adminSecurityAPI.getServerSecurityConnection(userId, serverName);
    }

    @DeleteMapping(path={"/servers/{serverName}/security/connection"})
    public synchronized VoidResponse clearServerSecurityConnection(@PathVariable String userId, @PathVariable String serverName) {
        return adminSecurityAPI.clearServerSecurityConnection(userId, serverName);
    }
}

