/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.spring;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.odpi.openmetadata.adminservices.OMAGServerAdminServices;
import org.odpi.openmetadata.adminservices.configuration.properties.CohortConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.LocalRepositoryConfig;
import org.odpi.openmetadata.adminservices.rest.CohortConfigResponse;
import org.odpi.openmetadata.adminservices.rest.ConnectionListResponse;
import org.odpi.openmetadata.adminservices.rest.LocalRepositoryConfigResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.StringResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/open-metadata/admin-services/users/{userId}/servers/{serverName}"})
public class ConfigRepositoryServicesResource {
    private OMAGServerAdminServices adminAPI = new OMAGServerAdminServices();

    @PostMapping(path={"/audit-log-destinations/default"})
    public VoidResponse setDefaultAuditLog(@PathVariable String userId, @PathVariable String serverName, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.adminAPI.setDefaultAuditLog(userId, serverName, requestBody);
    }

    @PostMapping(path={"/audit-log-destinations/console"})
    public VoidResponse addConsoleAuditLogDestination(@PathVariable String userId, @PathVariable String serverName, @RequestBody List<String> supportedSeverities) {
        return this.adminAPI.addConsoleAuditLogDestination(userId, serverName, supportedSeverities);
    }

    @PostMapping(path={"/audit-log-destinations/slf4j"})
    public VoidResponse addSLF4JAuditLogDestination(@PathVariable String userId, @PathVariable String serverName, @RequestBody List<String> supportedSeverities) {
        return this.adminAPI.addSLF4JAuditLogDestination(userId, serverName, supportedSeverities);
    }

    @PostMapping(path={"/audit-log-destinations/files"})
    public VoidResponse addFileAuditLogDestination(@PathVariable String userId, @PathVariable String serverName, @RequestBody List<String> supportedSeverities) {
        return this.adminAPI.addFileAuditLogDestination(userId, serverName, supportedSeverities);
    }

    @PostMapping(path={"/audit-log-destinations/event-topic"})
    public VoidResponse addEventTopicAuditLogDestination(@PathVariable String userId, @PathVariable String serverName, @RequestBody List<String> supportedSeverities) {
        return this.adminAPI.addEventTopicAuditLogDestination(userId, serverName, supportedSeverities);
    }

    @PostMapping(path={"/audit-log-destinations/connection"})
    public VoidResponse addAuditLogDestination(@PathVariable String userId, @PathVariable String serverName, @RequestBody Connection connection) {
        return this.adminAPI.addAuditLogDestination(userId, serverName, connection);
    }

    @PostMapping(path={"/open-metadata-archives/file"})
    public VoidResponse addStartUpOpenMetadataArchiveFile(@PathVariable String userId, @PathVariable String serverName, @RequestBody String fileName) {
        return this.adminAPI.addStartUpOpenMetadataArchiveFile(userId, serverName, fileName);
    }

    @DeleteMapping(path={"/local-repository"})
    public VoidResponse setNoRepositoryMode(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.setNoRepositoryMode(userId, serverName);
    }

    @PostMapping(path={"/local-repository/mode/in-memory-repository"})
    public VoidResponse setInMemLocalRepository(@PathVariable String userId, @PathVariable String serverName, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.adminAPI.setInMemLocalRepository(userId, serverName, requestBody);
    }

    @PostMapping(path={"/local-repository/mode/local-graph-repository"})
    public VoidResponse setGraphLocalRepository(@PathVariable String userId, @PathVariable String serverName, @RequestBody @Nullable Map<String, Object> storageProperties) {
        return this.adminAPI.setGraphLocalRepository(userId, serverName, storageProperties);
    }

    @PostMapping(path={"/local-repository/mode/read-only-repository"})
    public VoidResponse setGraphLocalRepository(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.setReadOnlyLocalRepository(userId, serverName);
    }

    @PostMapping(path={"/local-repository/mode/repository-proxy/connection"})
    public VoidResponse setRepositoryProxyConnection(@PathVariable String userId, @PathVariable String serverName, @RequestBody Connection connection) {
        return this.adminAPI.setRepositoryProxyConnection(userId, serverName, connection);
    }

    @PostMapping(path={"/local-repository/mode/repository-proxy/details"})
    public VoidResponse setRepositoryProxyConnection(@PathVariable String userId, @PathVariable String serverName, @RequestParam String connectorProvider, @RequestBody(required=false) Map<String, Object> additionalProperties) {
        return this.adminAPI.setRepositoryProxyConnection(userId, serverName, connectorProvider, additionalProperties);
    }

    @PostMapping(path={"/local-repository/event-mapper-connection"})
    public VoidResponse setLocalRepositoryEventMapper(@PathVariable String userId, @PathVariable String serverName, @RequestBody Connection connection) {
        return this.adminAPI.setLocalRepositoryEventMapper(userId, serverName, connection);
    }

    @PostMapping(path={"/local-repository/event-mapper-details"})
    public VoidResponse setLocalRepositoryEventMapper(@PathVariable String userId, @PathVariable String serverName, @RequestParam String connectorProvider, @RequestParam String eventSource, @RequestBody(required=false) Map<String, Object> additionalProperties) {
        return this.adminAPI.setLocalRepositoryEventMapper(userId, serverName, connectorProvider, eventSource, additionalProperties);
    }

    @PostMapping(path={"/local-repository/metadata-collection-name/{name}"})
    public VoidResponse setLocalMetadataCollectionName(@PathVariable String userId, @PathVariable String serverName, @PathVariable String name) {
        return this.adminAPI.setLocalMetadataCollectionName(userId, serverName, name);
    }

    @GetMapping(path={"/local-repository/metadata-collection-id"})
    public GUIDResponse getLocalMetadataCollectionId(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.getLocalMetadataCollectionId(userId, serverName);
    }

    @PostMapping(path={"/cohorts/{cohortName}"})
    public VoidResponse addCohortConfig(@PathVariable String userId, @PathVariable String serverName, @PathVariable String cohortName, @RequestBody(required=false) Map<String, Object> additionalProperties) {
        return this.adminAPI.addCohortConfig(userId, serverName, cohortName, additionalProperties);
    }

    @GetMapping(path={"/cohorts/{cohortName}"})
    public CohortConfigResponse getCohortConfig(@PathVariable String userId, @PathVariable String serverName, @PathVariable String cohortName) {
        return this.adminAPI.getCohortConfig(userId, serverName, cohortName);
    }

    @GetMapping(path={"/cohorts/{cohortName}/topic-name"})
    public StringResponse getCohortTopicName(@PathVariable String userId, @PathVariable String serverName, @PathVariable String cohortName) {
        return this.adminAPI.getCohortTopicName(userId, serverName, cohortName);
    }

    @PostMapping(path={"/cohorts/{cohortName}/topic-name-override"})
    public VoidResponse overrideCohortTopicName(@PathVariable String userId, @PathVariable String serverName, @PathVariable String cohortName, @RequestBody String topicName) {
        return this.adminAPI.overrideCohortTopicName(userId, serverName, cohortName, topicName);
    }

    @DeleteMapping(path={"/cohorts/{cohortName}"})
    public VoidResponse clearCohortConfig(@PathVariable String userId, @PathVariable String serverName, @PathVariable String cohortName) {
        return this.adminAPI.clearCohortConfig(userId, serverName, cohortName);
    }

    @PostMapping(path={"/audit-log-destinations"})
    public VoidResponse setAuditLogDestinations(@PathVariable String userId, @PathVariable String serverName, @RequestBody List<Connection> auditLogDestinations) {
        return this.adminAPI.setAuditLogDestinations(userId, serverName, auditLogDestinations);
    }

    @GetMapping(path={"/audit-log-destinations"})
    public ConnectionListResponse getAuditLogDestinations(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.getAuditLogDestinations(userId, serverName);
    }

    @DeleteMapping(path={"/audit-log-destinations"})
    public VoidResponse clearAuditLogDestinations(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.clearAuditLogDestinations(userId, serverName);
    }

    @PostMapping(path={"/open-metadata-archives"})
    public VoidResponse setOpenMetadataArchives(@PathVariable String userId, @PathVariable String serverName, @RequestBody List<Connection> openMetadataArchives) {
        return this.adminAPI.setOpenMetadataArchives(userId, serverName, openMetadataArchives);
    }

    @GetMapping(path={"/open-metadata-archives"})
    public ConnectionListResponse getOpenMetadataArchives(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.getOpenMetadataArchives(userId, serverName);
    }

    @DeleteMapping(path={"/open-metadata-archives"})
    public VoidResponse clearOpenMetadataArchives(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.clearOpenMetadataArchives(userId, serverName);
    }

    @PostMapping(path={"/local-repository/configuration"})
    public VoidResponse setLocalRepositoryConfig(@PathVariable String userId, @PathVariable String serverName, @RequestBody LocalRepositoryConfig localRepositoryConfig) {
        return this.adminAPI.setLocalRepositoryConfig(userId, serverName, localRepositoryConfig);
    }

    @GetMapping(path={"/local-repository/configuration"})
    public LocalRepositoryConfigResponse getLocalRepositoryConfig(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.getLocalRepositoryConfig(userId, serverName);
    }

    @DeleteMapping(path={"/local-repository/configuration"})
    public VoidResponse clearLocalRepositoryConfig(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.clearLocalRepositoryConfig(userId, serverName);
    }

    @PostMapping(path={"/cohorts/{cohortName}/configuration"})
    public VoidResponse setCohortConfig(@PathVariable String userId, @PathVariable String serverName, @PathVariable String cohortName, @RequestBody CohortConfig cohortConfig) {
        return this.adminAPI.setCohortConfig(userId, serverName, cohortName, cohortConfig);
    }
}

