/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.spring;

import java.util.List;
import org.odpi.openmetadata.adminservices.OMAGServerConfigStewardshipEngineServices;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerClientConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.StewardshipEngineServicesConfig;
import org.odpi.openmetadata.adminservices.rest.StewardshipEngineServicesConfigResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/open-metadata/admin-services/users/{userId}/servers/{serverName}/stewardship-engine-services"})
public class ConfigStewardshipEngineServicesResource {
    private OMAGServerConfigStewardshipEngineServices adminAPI = new OMAGServerConfigStewardshipEngineServices();

    @PostMapping(path={"/client-config"})
    public VoidResponse setClientConfig(@PathVariable String userId, @PathVariable String serverName, @RequestBody OMAGServerClientConfig clientConfig) {
        return this.adminAPI.setClientConfig(userId, serverName, clientConfig);
    }

    @PostMapping(path={"/stewardship-engines"})
    public VoidResponse setStewardshipEngines(@PathVariable String userId, @PathVariable String serverName, @RequestBody List<String> stewardshipEngines) {
        return this.adminAPI.setStewardshipEngines(userId, serverName, stewardshipEngines);
    }

    @PostMapping(path={""})
    public VoidResponse setStewardshipEngineServicesConfig(@PathVariable String userId, @PathVariable String serverName, @RequestBody StewardshipEngineServicesConfig servicesConfig) {
        return this.adminAPI.setStewardshipEngineServicesConfig(userId, serverName, servicesConfig);
    }

    @GetMapping(path={""})
    public StewardshipEngineServicesConfigResponse getStewardshipEngineServicesConfig(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.getStewardshipEngineServicesConfig(userId, serverName);
    }

    @DeleteMapping(path={""})
    public VoidResponse clearStewardshipEngineServicesConfig(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.clearStewardshipEngineServicesConfig(userId, serverName);
    }
}

