/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.spring;

import java.util.List;
import org.odpi.openmetadata.adminservices.OMAGServerAdminForViewServices;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerClientConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.ViewServiceConfig;
import org.odpi.openmetadata.adminservices.rest.ViewServicesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.RegisteredOMAGServicesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/open-metadata/admin-services/users/{userId}/servers/{serverName}/view-services"})
public class ConfigViewServicesResource {
    private OMAGServerAdminForViewServices adminAPI = new OMAGServerAdminForViewServices();

    @GetMapping(path={"/configuration"})
    public RegisteredOMAGServicesResponse getConfiguredViewServices(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.getConfiguredViewServices(userId, serverName);
    }

    @GetMapping
    public ViewServicesResponse getViewServices(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.getViewServices(userId, serverName);
    }

    @PostMapping(path={"/{serviceURLMarker}"})
    public VoidResponse configureViewService(@PathVariable String userId, @PathVariable String serverName, @PathVariable String serviceURLMarker, @RequestBody OMAGServerClientConfig clientConfig) {
        return this.adminAPI.configureViewService(userId, serverName, serviceURLMarker, clientConfig);
    }

    @PostMapping
    public VoidResponse configureAllViewServices(@PathVariable String userId, @PathVariable String serverName, @RequestBody OMAGServerClientConfig clientConfig) {
        return this.adminAPI.configureAllViewServices(userId, serverName, clientConfig);
    }

    @DeleteMapping
    public VoidResponse clearAllViewServices(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.clearAllViewServices(userId, serverName);
    }

    @PostMapping(path={"/configuration"})
    public VoidResponse setViewServicesConfig(@PathVariable String userId, @PathVariable String serverName, @RequestBody List<ViewServiceConfig> viewServicesConfig) {
        return this.adminAPI.setViewServicesConfig(userId, serverName, viewServicesConfig);
    }
}

