/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.adminservices.OMAGServerAdminServices;
import org.odpi.openmetadata.adminservices.rest.OMAGServerConfigsResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/open-metadata/admin-services/users/{userId}/configurations"})
@Tag(name="Administration Services - Server Configurations", description="The server configurations administration services support the configuration of the open metadata and governance services within an OMAG Server. A configuration determines which of the Open Metadata and Governance (OMAG) services are active.", externalDocs=@ExternalDocumentation(description="Further information", url="https://egeria.odpi.org/open-metadata-implementation/admin-services/docs/user/configuring-an-omag-server.html"))
public class ConfigsResource {
    private OMAGServerAdminServices adminAPI = new OMAGServerAdminServices();

    @GetMapping
    public OMAGServerConfigsResponse getStoredConfigurations(@PathVariable String userId) {
        return this.adminAPI.retrieveAllServerConfigs(userId);
    }
}

