/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.adminservices.OMAGServerAdminSecurityServices;
import org.odpi.openmetadata.adminservices.rest.ConnectionResponse;
import org.odpi.openmetadata.adminservices.rest.PlatformSecurityRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/open-metadata/admin-services/users/{userId}/platform/security"})
@Tag(name="Administration Services - Platform Configuration", description="The platform configuration administration services support the configuration of the security and configuration store connectors for an OMAG Server Platform.", externalDocs=@ExternalDocumentation(description="Further information", url="https://egeria.odpi.org/open-metadata-implementation/admin-services/docs/user/configuring-the-omag-server-platform.html"))
public class ConfigOpenMetadataPlatformSecurityResource {
    private static OMAGServerAdminSecurityServices adminSecurityAPI = new OMAGServerAdminSecurityServices();

    @PostMapping(path={"/connection"})
    public VoidResponse setPlatformSecurityConnection(@PathVariable String userId, @RequestBody PlatformSecurityRequestBody requestBody) {
        return adminSecurityAPI.setPlatformSecurityConnection(userId, requestBody);
    }

    @GetMapping(path={"/connection"})
    public ConnectionResponse getPlatformSecurityConnection(@PathVariable String userId) {
        return adminSecurityAPI.getPlatformSecurityConnection(userId);
    }

    @DeleteMapping(path={"/connection"})
    public VoidResponse clearPlatformSecurityConnection(@PathVariable String userId) {
        return adminSecurityAPI.clearPlatformSecurityConnection(userId);
    }
}

