/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.odpi.openmetadata.adminservices.OMAGServerAdminForEngineServices;
import org.odpi.openmetadata.adminservices.configuration.properties.EngineHostServicesConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.EngineServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerClientConfig;
import org.odpi.openmetadata.adminservices.rest.EngineHostServicesResponse;
import org.odpi.openmetadata.adminservices.rest.EngineServiceConfigResponse;
import org.odpi.openmetadata.adminservices.rest.EngineServiceRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.RegisteredOMAGServicesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/open-metadata/admin-services/users/{userId}/servers/{serverName}"})
@Tag(name="Administration Services - Server Configuration", description="The server configuration administration services support the configuration of the open metadata and governance services within an OMAG Server. This configuration determines which of the Open Metadata and Governance (OMAG) services are active.", externalDocs=@ExternalDocumentation(description="Further information", url="https://egeria.odpi.org/open-metadata-implementation/admin-services/docs/user/configuring-an-omag-server.html"))
public class ConfigEngineServicesResource {
    private OMAGServerAdminForEngineServices adminAPI = new OMAGServerAdminForEngineServices();

    @GetMapping(value={"/engine-services"})
    public RegisteredOMAGServicesResponse getConfiguredEngineServices(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.getConfiguredEngineServices(userId, serverName);
    }

    @GetMapping(value={"/engine-host-services/configuration"})
    public EngineHostServicesResponse getEngineHostServicesConfiguration(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.getEngineHostServicesConfiguration(userId, serverName);
    }

    @GetMapping(value={"/engine-services/{serviceURLMarker}/configuration"})
    public EngineServiceConfigResponse getEngineServiceConfiguration(@PathVariable String userId, @PathVariable String serverName, @PathVariable String serviceURLMarker) {
        return this.adminAPI.getEngineServiceConfiguration(userId, serverName, serviceURLMarker);
    }

    @PostMapping(value={"/engine-definitions/client-config"})
    public VoidResponse setEngineDefinitionsClientConfig(@PathVariable String userId, @PathVariable String serverName, @RequestBody OMAGServerClientConfig clientConfig) {
        return this.adminAPI.setEngineDefinitionsClientConfig(userId, serverName, clientConfig);
    }

    @PostMapping(path={"/engine-services/{serviceURLMarker}"})
    public VoidResponse configureEngineService(@PathVariable String userId, @PathVariable String serverName, @PathVariable String serviceURLMarker, @RequestBody EngineServiceRequestBody requestBody) {
        return this.adminAPI.configureEngineService(userId, serverName, serviceURLMarker, requestBody);
    }

    @PostMapping(path={"/engine-services/configuration"})
    public VoidResponse configureEngineService(@PathVariable String userId, @PathVariable String serverName, @RequestBody EngineServiceConfig serviceConfig) {
        return this.adminAPI.configureEngineService(userId, serverName, serviceConfig);
    }

    @PostMapping(path={"/engine-services/configuration/all"})
    public VoidResponse setEngineServicesConfig(@PathVariable String userId, @PathVariable String serverName, @RequestBody List<EngineServiceConfig> engineServicesConfig) {
        return this.adminAPI.setEngineServicesConfig(userId, serverName, engineServicesConfig);
    }

    @PostMapping(path={"/engine-host-services"})
    public VoidResponse setEngineHostServicesConfig(@PathVariable String userId, @PathVariable String serverName, @RequestBody EngineHostServicesConfig servicesConfig) {
        return this.adminAPI.setEngineHostServicesConfig(userId, serverName, servicesConfig);
    }

    @DeleteMapping(path={"/engine-host-services"})
    public VoidResponse clearEngineHostServicesConfig(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.clearEngineHostServicesConfig(userId, serverName);
    }

    @DeleteMapping(path={"/engine-definitions/client-config"})
    public VoidResponse clearEngineDefinitionsClientConfig(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.clearEngineDefinitionsClientConfig(userId, serverName);
    }

    @DeleteMapping(path={"/engine-services"})
    public VoidResponse clearAllEngineServices(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.clearAllEngineServices(userId, serverName);
    }

    @DeleteMapping(path={"/engine-services/{serviceURLMarker}"})
    public VoidResponse clearEngineService(@PathVariable String userId, @PathVariable String serverName, @PathVariable String serviceURLMarker) {
        return this.adminAPI.clearEngineService(userId, serverName, serviceURLMarker);
    }
}

