/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.adminservices.OMAGConformanceSuiteConfigServices;
import org.odpi.openmetadata.adminservices.configuration.properties.RepositoryConformanceWorkbenchConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.RepositoryPerformanceWorkbenchConfig;
import org.odpi.openmetadata.adminservices.rest.URLRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/open-metadata/admin-services/users/{userId}/servers/{serverName}"})
@Tag(name="Administration Services - Server Configuration", description="The server configuration administration services support the configuration of the open metadata and governance services within an OMAG Server. This configuration determines which of the Open Metadata and Governance (OMAG) services are active.", externalDocs=@ExternalDocumentation(description="Further information", url="https://egeria-project.org/guides/admin/servers/"))
public class ConfigConformanceSuiteServicesResource {
    private OMAGConformanceSuiteConfigServices adminAPI = new OMAGConformanceSuiteConfigServices();

    @PostMapping(path={"/conformance-suite-workbenches/repository-workbench/repositories"})
    public VoidResponse enableRepositoryConformanceSuiteWorkbench(@PathVariable String userId, @PathVariable String serverName, @RequestBody RepositoryConformanceWorkbenchConfig repositoryConformanceWorkbenchConfig) {
        return this.adminAPI.enableRepositoryConformanceSuiteWorkbench(userId, serverName, repositoryConformanceWorkbenchConfig);
    }

    @PostMapping(path={"/conformance-suite-workbenches/repository-workbench/performance"})
    public VoidResponse enableRepositoryPerformanceSuiteWorkbench(@PathVariable String userId, @PathVariable String serverName, @RequestBody RepositoryPerformanceWorkbenchConfig repositoryPerformanceWorkbenchConfig) {
        return this.adminAPI.enableRepositoryPerformanceSuiteWorkbench(userId, serverName, repositoryPerformanceWorkbenchConfig);
    }

    @PostMapping(path={"/conformance-suite-workbenches/platform-workbench/platforms"})
    public VoidResponse enablePlatformConformanceSuiteWorkbench(@PathVariable String userId, @PathVariable String serverName, @RequestBody URLRequestBody requestBody) {
        return this.adminAPI.enablePlatformConformanceSuiteWorkbench(userId, serverName, requestBody);
    }

    @DeleteMapping(path={"/conformance-suite-workbenches/repository-workbench"})
    public VoidResponse disableRepositoryConformanceSuiteServices(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.disableRepositoryConformanceSuiteServices(userId, serverName);
    }

    @DeleteMapping(path={"/conformance-suite-workbenches/platform-workbench"})
    public VoidResponse disablePlatformConformanceSuiteServices(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.disablePlatformConformanceSuiteServices(userId, serverName);
    }

    @DeleteMapping(path={"/conformance-suite-workbenches"})
    public VoidResponse disableAllConformanceSuiteWorkbenches(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.disableAllConformanceSuiteWorkbenches(userId, serverName);
    }
}

