/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.adminservices.OMAGServerAdminStoreServices;
import org.odpi.openmetadata.adminservices.rest.ConnectionResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/open-metadata/admin-services/users/{userId}/stores"})
@Tag(name="Administration Services - Platform Configuration", description="The platform configuration administration services support the configuration of the security and configuration store connectors for an OMAG Server Platform.", externalDocs=@ExternalDocumentation(description="Further information", url="https://egeria-project.org/guides/admin/servers/"))
public class ConfigStoreResource {
    private final OMAGServerAdminStoreServices adminStoreAPI = new OMAGServerAdminStoreServices();

    @PostMapping(path={"/connection"})
    public VoidResponse setConfigurationStoreConnection(@PathVariable String userId, @RequestBody Connection connection) {
        return this.adminStoreAPI.setConfigurationStoreConnection(userId, connection);
    }

    @GetMapping(path={"/connection"})
    public ConnectionResponse getConfigurationStoreConnection(@PathVariable String userId) {
        return this.adminStoreAPI.getConfigurationStoreConnection(userId);
    }

    @DeleteMapping(path={"/connection"})
    public VoidResponse clearConfigurationStoreConnection(@PathVariable String userId) {
        return this.adminStoreAPI.clearConfigurationStoreConnection(userId);
    }
}

