/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.odpi.openmetadata.adminservices.OMAGServerAdminForViewServices;
import org.odpi.openmetadata.adminservices.configuration.properties.ViewServiceConfig;
import org.odpi.openmetadata.adminservices.rest.ViewServiceConfigResponse;
import org.odpi.openmetadata.adminservices.rest.ViewServicesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.RegisteredOMAGServicesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/open-metadata/admin-services/users/{userId}/servers/{serverName}"})
@Tag(name="Administration Services - Server Configuration", description="The server configuration administration services support the configuration of the open metadata and governance services within an OMAG Server. This configuration determines which of the Open Metadata and Governance (OMAG) services are active.", externalDocs=@ExternalDocumentation(description="Further information", url="https://egeria-project.org/guides/admin/servers/"))
public class ConfigViewServicesResource {
    private final OMAGServerAdminForViewServices adminAPI = new OMAGServerAdminForViewServices();

    @GetMapping(path={"/view-services"})
    public RegisteredOMAGServicesResponse getConfiguredViewServices(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.getConfiguredViewServices(userId, serverName);
    }

    @GetMapping(path={"/view-services/configuration"})
    public ViewServicesResponse getViewServicesConfiguration(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.getViewServicesConfiguration(userId, serverName);
    }

    @GetMapping(value={"/view-services/{serviceURLMarker}"})
    public ViewServiceConfigResponse getViewServiceConfig(@PathVariable String userId, @PathVariable String serverName, @PathVariable String serviceURLMarker) {
        return this.adminAPI.getViewServiceConfig(userId, serverName, serviceURLMarker);
    }

    @PostMapping(path={"/view-services/{serviceURLMarker}"})
    public VoidResponse configureViewService(@PathVariable String userId, @PathVariable String serverName, @PathVariable String serviceURLMarker, @RequestBody ViewServiceConfig requestBody) {
        return this.adminAPI.configureViewService(userId, serverName, serviceURLMarker, requestBody);
    }

    @PostMapping(path={"/view-services/configuration"})
    public VoidResponse setViewServicesConfig(@PathVariable String userId, @PathVariable String serverName, @RequestBody List<ViewServiceConfig> viewServicesConfig) {
        return this.adminAPI.setViewServicesConfig(userId, serverName, viewServicesConfig);
    }

    @DeleteMapping(path={"/view-services/{serviceURLMarker}"})
    public VoidResponse clearViewService(@PathVariable String userId, @PathVariable String serverName, @PathVariable String serviceURLMarker) {
        return this.adminAPI.clearViewService(userId, serverName, serviceURLMarker);
    }

    @DeleteMapping(path={"/view-services"})
    public VoidResponse clearAllViewServices(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.clearAllViewServices(userId, serverName);
    }
}

