/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.adminservices.server.OMAGServerOriginServices;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/open-metadata/admin-services/users/{userId}"})
@Tag(name="Administration Services - Operational", description="The operational administration services support the management of OMAG Server instances.  This includes starting and stopping the servers as well as querying and changing their operational state.", externalDocs=@ExternalDocumentation(description="Further information", url="https://egeria-project.org/guides/operations/overview/"))
public class ServerOriginResource {
    private final OMAGServerOriginServices originAPI = new OMAGServerOriginServices();

    @GetMapping(path={"/servers/{serverName}/server-origin"})
    @Deprecated
    public String getServerOrigin(@PathVariable String userId, @PathVariable String serverName) {
        return this.originAPI.getServerOrigin(userId);
    }

    @GetMapping(path={"/server-origin"})
    @Deprecated
    public String getServerOrigin(@PathVariable String userId) {
        return this.originAPI.getServerOrigin(userId);
    }
}

