/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.odpi.openmetadata.adminservices.OMAGServerAdminForIntegrationServices;
import org.odpi.openmetadata.adminservices.configuration.properties.IntegrationServiceConfig;
import org.odpi.openmetadata.adminservices.rest.IntegrationServiceConfigResponse;
import org.odpi.openmetadata.adminservices.rest.IntegrationServiceRequestBody;
import org.odpi.openmetadata.adminservices.rest.IntegrationServicesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.RegisteredOMAGServicesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/open-metadata/admin-services/users/{userId}/servers/{serverName}"})
@Tag(name="Administration Services - Server Configuration", description="The server configuration administration services support the configuration of the open metadata and governance services within an OMAG Server. This configuration determines which of the Open Metadata and Governance (OMAG) services are active.", externalDocs=@ExternalDocumentation(description="Further information", url="https://egeria.odpi.org/open-metadata-implementation/admin-services/docs/user/configuring-an-omag-server.html"))
public class ConfigIntegrationServicesResource {
    private OMAGServerAdminForIntegrationServices adminAPI = new OMAGServerAdminForIntegrationServices();

    @GetMapping(value={"/integration-services"})
    public RegisteredOMAGServicesResponse getRegisteredIntegrationServices(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.getRegisteredIntegrationServices(userId, serverName);
    }

    @GetMapping(value={"/integration-services/configuration"})
    public IntegrationServicesResponse getIntegrationServicesConfiguration(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.getIntegrationServicesConfiguration(userId, serverName);
    }

    @GetMapping(value={"/integration-services/{serviceURLMarker}/configuration"})
    public IntegrationServiceConfigResponse getIntegrationServiceConfiguration(@PathVariable String userId, @PathVariable String serverName, @PathVariable String serviceURLMarker) {
        return this.adminAPI.getIntegrationServiceConfiguration(userId, serverName, serviceURLMarker);
    }

    @PostMapping(path={"/integration-services/{serviceURLMarker}"})
    public VoidResponse configureIntegrationService(@PathVariable String userId, @PathVariable String serverName, @PathVariable String serviceURLMarker, @RequestBody IntegrationServiceRequestBody requestBody) {
        return this.adminAPI.configureIntegrationService(userId, serverName, serviceURLMarker, requestBody);
    }

    @PostMapping(path={"/integration-services/configuration"})
    public VoidResponse configureIntegrationService(@PathVariable String userId, @PathVariable String serverName, @RequestBody IntegrationServiceConfig serviceConfig) {
        return this.adminAPI.configureIntegrationService(userId, serverName, serviceConfig);
    }

    @PostMapping(path={"/integration-services/configuration/all"})
    public VoidResponse setIntegrationServicesConfig(@PathVariable String userId, @PathVariable String serverName, @RequestBody List<IntegrationServiceConfig> integrationServicesConfig) {
        return this.adminAPI.setIntegrationServicesConfig(userId, serverName, integrationServicesConfig);
    }

    @DeleteMapping(path={"/integration-services"})
    public VoidResponse clearAllIntegrationServices(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.clearAllIntegrationServices(userId, serverName);
    }

    @DeleteMapping(path={"/integration-services/{serviceURLMarker}"})
    public VoidResponse clearIntegrationService(@PathVariable String userId, @PathVariable String serverName, @PathVariable String serviceURLMarker) {
        return this.adminAPI.clearIntegrationService(userId, serverName, serviceURLMarker);
    }
}

