/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.adminservices.OMAGServerAdminServices;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.rest.OMAGServerConfigResponse;
import org.odpi.openmetadata.adminservices.rest.URLRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/open-metadata/admin-services/users/{userId}/servers/{serverName}"})
@Tag(name="Administration Services - Server Configuration", description="The server configuration administration services support the configuration of the open metadata and governance services within an OMAG Server. This configuration determines which of the Open Metadata and Governance (OMAG) services are active.", externalDocs=@ExternalDocumentation(description="Further information", url="https://egeria.odpi.org/open-metadata-implementation/admin-services/docs/user/configuring-an-omag-server.html"))
public class ConfigResource {
    private OMAGServerAdminServices adminAPI = new OMAGServerAdminServices();

    @GetMapping(path={"/configuration"})
    public OMAGServerConfigResponse getStoredConfiguration(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.getStoredConfiguration(userId, serverName);
    }

    @PostMapping(path={"/configuration"})
    public VoidResponse setOMAGServerConfig(@PathVariable String userId, @PathVariable String serverName, @RequestBody OMAGServerConfig omagServerConfig) {
        return this.adminAPI.setOMAGServerConfig(userId, serverName, omagServerConfig);
    }

    @DeleteMapping(path={"/configuration"})
    public VoidResponse clearOMAGServerConfig(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.clearOMAGServerConfig(userId, serverName);
    }

    @PostMapping(path={"/configuration/deploy"})
    public VoidResponse deployOMAGServerConfig(@PathVariable String userId, @PathVariable String serverName, @RequestBody URLRequestBody destinationPlatform) {
        return this.adminAPI.deployOMAGServerConfig(userId, serverName, destinationPlatform);
    }
}

