/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.adminservices.OMAGServerOperationalServices;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.rest.OMAGServerConfigResponse;
import org.odpi.openmetadata.adminservices.rest.SuccessMessageResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/open-metadata/admin-services/users/{userId}/servers/{serverName}"})
@Tag(name="Administration Services - Operational", description="The operational administration services support the management of OMAG Server instances.  This includes starting and stopping the servers as well as querying and changing their operational state.", externalDocs=@ExternalDocumentation(description="Further information", url="https://egeria.odpi.org/open-metadata-implementation/admin-services/docs/user/operating-omag-server.html"))
public class OperationalServicesResource {
    private OMAGServerOperationalServices operationalServices = new OMAGServerOperationalServices();

    @PostMapping(path={"/instance"})
    @Operation(summary="Activate server with stored configuration document", description="Activate the named OMAG server using the appropriate configuration document found in the configuration store.", externalDocs=@ExternalDocumentation(description="Configuration Documents", url="https://egeria.odpi.org/open-metadata-implementation/admin-services/docs/concepts/configuration-document.html"))
    public SuccessMessageResponse activateWithStoredConfig(@PathVariable String userId, @PathVariable String serverName) {
        return this.operationalServices.activateWithStoredConfig(userId, serverName);
    }

    @PostMapping(path={"/instance/configuration"})
    @Operation(summary="Activate server with supplied configuration document", description="Activate the named OMAG server using the supplied configuration document. This configuration document is added to the configuration store, over-writing any previous configuration for this server.", externalDocs=@ExternalDocumentation(description="Configuration Documents", url="https://egeria.odpi.org/open-metadata-implementation/admin-services/docs/concepts/configuration-document.html"))
    public SuccessMessageResponse activateWithSuppliedConfig(@PathVariable String userId, @PathVariable String serverName, @RequestBody OMAGServerConfig configuration) {
        return this.operationalServices.activateWithSuppliedConfig(userId, serverName, configuration);
    }

    @DeleteMapping(path={"/instance"})
    @Operation(summary="Shutdown server", description="Temporarily shutdown the named OMAG server.  This server can be restarted as a later time.")
    public VoidResponse deactivateTemporarily(@PathVariable String userId, @PathVariable String serverName) {
        return this.operationalServices.deactivateTemporarily(userId, serverName);
    }

    @DeleteMapping(path={""})
    @Operation(summary="Shutdown and delete server", description="Permanently shutdown the named OMAG server and delete its configuration.  The server will also be removed from any open metadata repository cohorts it has registered with.")
    public VoidResponse deactivatePermanently(@PathVariable String userId, @PathVariable String serverName) {
        return this.operationalServices.deactivatePermanently(userId, serverName);
    }

    @GetMapping(path={"/instance/configuration"})
    @Operation(summary="Retrieve active server's running configuration", description="Retrieve the configuration document used to start a running instance of a server. The stored configuration document may have changed since the server was started.  This operation makes it possible to verify the configuration values actually being used in the running server. \n\nNull is returned if the server is not running.", externalDocs=@ExternalDocumentation(description="Configuration Documents", url="https://egeria.odpi.org/open-metadata-implementation/admin-services/docs/concepts/configuration-document.html"))
    public OMAGServerConfigResponse getActiveConfiguration(@PathVariable String userId, @PathVariable String serverName) {
        return this.operationalServices.getActiveConfiguration(userId, serverName);
    }

    @PostMapping(path={"/instance/open-metadata-archives/file"})
    @Operation(summary="Load open metadata archive", description="An open metadata archive contains metadata types and instances.  This operation loads an open metadata archive that is readable through the connector identified by the connection.  It can be used with OMAG servers that are of type Cohort Member.", externalDocs=@ExternalDocumentation(description="Open Metadata Archives", url="https://egeria.odpi.org/open-metadata-resources/open-metadata-archives/index.html"))
    public VoidResponse addOpenMetadataArchiveFile(@PathVariable String userId, @PathVariable String serverName, @RequestBody String fileName) {
        return this.operationalServices.addOpenMetadataArchiveFile(userId, serverName, fileName);
    }

    @PostMapping(path={"/instance/open-metadata-archives/connection"})
    @Operation(summary="Load open metadata archive", description="An open metadata archive contains metadata types and instances.  This operation loads an open metadata archive that is readable through the connector identified by the connection.  It can be used with OMAG servers that are of type Cohort Member.", externalDocs=@ExternalDocumentation(description="Open Metadata Archives", url="https://egeria.odpi.org/open-metadata-resources/open-metadata-archives/index.html"))
    public VoidResponse addOpenMetadataArchive(@PathVariable String userId, @PathVariable String serverName, @RequestBody Connection connection) {
        return this.operationalServices.addOpenMetadataArchive(userId, serverName, connection);
    }
}

