/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.odpi.openmetadata.adminservices.OMAGServerAdminServices;
import org.odpi.openmetadata.adminservices.configuration.properties.CohortConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.CohortTopicStructure;
import org.odpi.openmetadata.adminservices.configuration.properties.LocalRepositoryConfig;
import org.odpi.openmetadata.adminservices.rest.CohortConfigResponse;
import org.odpi.openmetadata.adminservices.rest.ConnectionListResponse;
import org.odpi.openmetadata.adminservices.rest.DedicatedTopicListResponse;
import org.odpi.openmetadata.adminservices.rest.LocalRepositoryConfigResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.StringResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/open-metadata/admin-services/users/{userId}/servers/{serverName}"})
@Tag(name="Administration Services - Server Configuration", description="The server configuration administration services support the configuration of the open metadata and governance services within an OMAG Server. This configuration determines which of the Open Metadata and Governance (OMAG) services are active.", externalDocs=@ExternalDocumentation(description="Further information", url="https://odpi.github.io/egeria-docs/guides/admin/servers/"))
public class ConfigRepositoryServicesResource {
    private OMAGServerAdminServices adminAPI = new OMAGServerAdminServices();

    @PostMapping(path={"/audit-log-destinations/default"})
    public VoidResponse setDefaultAuditLog(@PathVariable String userId, @PathVariable String serverName, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.adminAPI.setDefaultAuditLog(userId, serverName, requestBody);
    }

    @PostMapping(path={"/audit-log-destinations/console"})
    public VoidResponse addConsoleAuditLogDestination(@PathVariable String userId, @PathVariable String serverName, @RequestBody List<String> supportedSeverities) {
        return this.adminAPI.addConsoleAuditLogDestination(userId, serverName, supportedSeverities);
    }

    @PostMapping(path={"/audit-log-destinations/slf4j"})
    public VoidResponse addSLF4JAuditLogDestination(@PathVariable String userId, @PathVariable String serverName, @RequestBody List<String> supportedSeverities) {
        return this.adminAPI.addSLF4JAuditLogDestination(userId, serverName, supportedSeverities);
    }

    @PostMapping(path={"/audit-log-destinations/files"})
    public VoidResponse addFileAuditLogDestination(@PathVariable String userId, @PathVariable String serverName, @RequestBody List<String> supportedSeverities) {
        return this.adminAPI.addFileAuditLogDestination(userId, serverName, supportedSeverities);
    }

    @PostMapping(path={"/audit-log-destinations/event-topic"})
    public VoidResponse addEventTopicAuditLogDestination(@PathVariable String userId, @PathVariable String serverName, @RequestBody List<String> supportedSeverities) {
        return this.adminAPI.addEventTopicAuditLogDestination(userId, serverName, supportedSeverities);
    }

    @PostMapping(path={"/audit-log-destinations/connection"})
    public VoidResponse addAuditLogDestination(@PathVariable String userId, @PathVariable String serverName, @RequestBody Connection connection) {
        return this.adminAPI.addAuditLogDestination(userId, serverName, connection);
    }

    @PutMapping(path={"/audit-log-destinations/connection/{connectionName}"})
    public VoidResponse updateAuditLogDestination(@PathVariable String userId, @PathVariable String serverName, @PathVariable String connectionName, @RequestBody Connection connection) {
        return this.adminAPI.updateAuditLogDestination(userId, serverName, connectionName, connection);
    }

    @DeleteMapping(path={"/audit-log-destinations/connection/{connectionName}"})
    public VoidResponse deleteAuditLogDestination(@PathVariable String userId, @PathVariable String serverName, @PathVariable String connectionName) {
        return this.adminAPI.deleteAuditLogDestination(userId, serverName, connectionName);
    }

    @PostMapping(path={"/open-metadata-archives/file"})
    public VoidResponse addStartUpOpenMetadataArchiveFile(@PathVariable String userId, @PathVariable String serverName, @RequestBody String fileName) {
        return this.adminAPI.addStartUpOpenMetadataArchiveFile(userId, serverName, fileName);
    }

    @DeleteMapping(path={"/local-repository"})
    public VoidResponse setNoRepositoryMode(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.setNoRepositoryMode(userId, serverName);
    }

    @PostMapping(path={"/local-repository/mode/in-memory-repository"})
    public VoidResponse setInMemLocalRepository(@PathVariable String userId, @PathVariable String serverName, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.adminAPI.setInMemLocalRepository(userId, serverName, requestBody);
    }

    @PostMapping(path={"/local-repository/mode/local-graph-repository"})
    public VoidResponse setGraphLocalRepository(@PathVariable String userId, @PathVariable String serverName, @RequestBody @Nullable Map<String, Object> storageProperties) {
        return this.adminAPI.setGraphLocalRepository(userId, serverName, storageProperties);
    }

    @PostMapping(path={"/local-repository/mode/read-only-repository"})
    public VoidResponse setReadOnlyLocalRepository(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.setReadOnlyLocalRepository(userId, serverName);
    }

    @PostMapping(path={"/local-repository/mode/plugin-repository/connection"})
    public VoidResponse setPluginRepositoryConnection(@PathVariable String userId, @PathVariable String serverName, @RequestBody Connection connection) {
        return this.adminAPI.setPluginRepositoryConnection(userId, serverName, connection);
    }

    @PostMapping(path={"/local-repository/mode/plugin-repository/details"})
    public VoidResponse setPluginRepositoryConnection(@PathVariable String userId, @PathVariable String serverName, @RequestParam String connectorProvider, @RequestBody(required=false) Map<String, Object> additionalProperties) {
        return this.adminAPI.setPluginRepositoryConnection(userId, serverName, connectorProvider, additionalProperties);
    }

    @PostMapping(path={"/local-repository/mode/repository-proxy/connection"})
    public VoidResponse setRepositoryProxyConnection(@PathVariable String userId, @PathVariable String serverName, @RequestBody Connection connection) {
        return this.adminAPI.setRepositoryProxyConnection(userId, serverName, connection);
    }

    @PostMapping(path={"/local-repository/mode/repository-proxy/details"})
    public VoidResponse setRepositoryProxyConnection(@PathVariable String userId, @PathVariable String serverName, @RequestParam String connectorProvider, @RequestBody(required=false) Map<String, Object> additionalProperties) {
        return this.adminAPI.setRepositoryProxyConnection(userId, serverName, connectorProvider, additionalProperties);
    }

    @PostMapping(path={"/local-repository/event-mapper-connection"})
    public VoidResponse setRepositoryProxyEventMapper(@PathVariable String userId, @PathVariable String serverName, @RequestBody Connection connection) {
        return this.adminAPI.setRepositoryProxyEventMapper(userId, serverName, connection);
    }

    @PostMapping(path={"/local-repository/event-mapper-details"})
    public VoidResponse setRepositoryProxyEventMapper(@PathVariable String userId, @PathVariable String serverName, @RequestParam String connectorProvider, @RequestParam String eventSource, @RequestBody(required=false) Map<String, Object> additionalProperties) {
        return this.adminAPI.setRepositoryProxyEventMapper(userId, serverName, connectorProvider, eventSource, additionalProperties);
    }

    @PostMapping(path={"/local-repository/metadata-collection-name/{name}"})
    public VoidResponse setLocalMetadataCollectionName(@PathVariable String userId, @PathVariable String serverName, @PathVariable String name) {
        return this.adminAPI.setLocalMetadataCollectionName(userId, serverName, name);
    }

    @GetMapping(path={"/local-repository/metadata-collection-id"})
    public GUIDResponse getLocalMetadataCollectionId(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.getLocalMetadataCollectionId(userId, serverName);
    }

    @PostMapping(path={"/local-repository/metadata-collection-id"})
    public VoidResponse setLocalMetadataCollectionId(@PathVariable String userId, @PathVariable String serverName, @RequestBody String metadataCollectionId) {
        return this.adminAPI.setLocalMetadataCollectionId(userId, serverName, metadataCollectionId);
    }

    @PostMapping(path={"/cohorts/{cohortName}"})
    public VoidResponse addCohortRegistration(@PathVariable String userId, @PathVariable String serverName, @PathVariable String cohortName, @RequestBody(required=false) Map<String, Object> additionalProperties) {
        return this.adminAPI.addCohortRegistration(userId, serverName, cohortName, CohortTopicStructure.DEDICATED_TOPICS, additionalProperties);
    }

    @PostMapping(path={"/cohorts/{cohortName}/topic-structure/{cohortTopicStructure}"})
    public VoidResponse addCohortRegistration(@PathVariable String userId, @PathVariable String serverName, @PathVariable String cohortName, @PathVariable CohortTopicStructure cohortTopicStructure, @RequestBody(required=false) Map<String, Object> additionalProperties) {
        return this.adminAPI.addCohortRegistration(userId, serverName, cohortName, cohortTopicStructure, additionalProperties);
    }

    @GetMapping(path={"/cohorts/{cohortName}"})
    public CohortConfigResponse getCohortConfig(@PathVariable String userId, @PathVariable String serverName, @PathVariable String cohortName) {
        return this.adminAPI.getCohortConfig(userId, serverName, cohortName);
    }

    @GetMapping(path={"/cohorts/{cohortName}/topic-name"})
    public StringResponse getCohortTopicName(@PathVariable String userId, @PathVariable String serverName, @PathVariable String cohortName) {
        return this.adminAPI.getCohortTopicName(userId, serverName, cohortName);
    }

    @GetMapping(path={"/cohorts/{cohortName}/dedicated-topic-names"})
    public DedicatedTopicListResponse getDedicatedCohortTopicNames(@PathVariable String userId, @PathVariable String serverName, @PathVariable String cohortName) {
        return this.adminAPI.getDedicatedCohortTopicNames(userId, serverName, cohortName);
    }

    @PostMapping(path={"/cohorts/{cohortName}/topic-name-override"})
    public VoidResponse overrideCohortTopicName(@PathVariable String userId, @PathVariable String serverName, @PathVariable String cohortName, @RequestBody String topicName) {
        return this.adminAPI.overrideCohortTopicName(userId, serverName, cohortName, topicName);
    }

    @PostMapping(path={"/cohorts/{cohortName}/topic-name-override/registration"})
    public VoidResponse overrideRegistrationCohortTopicName(@PathVariable String userId, @PathVariable String serverName, @PathVariable String cohortName, @RequestBody String topicName) {
        return this.adminAPI.overrideRegistrationCohortTopicName(userId, serverName, cohortName, topicName);
    }

    @PostMapping(path={"/cohorts/{cohortName}/topic-name-override/types"})
    public VoidResponse overrideTypesCohortTopicName(@PathVariable String userId, @PathVariable String serverName, @PathVariable String cohortName, @RequestBody String topicName) {
        return this.adminAPI.overrideTypesCohortTopicName(userId, serverName, cohortName, topicName);
    }

    @PostMapping(path={"/cohorts/{cohortName}/topic-name-override/instances"})
    public VoidResponse overrideInstancesCohortTopicName(@PathVariable String userId, @PathVariable String serverName, @PathVariable String cohortName, @RequestBody String topicName) {
        return this.adminAPI.overrideInstancesCohortTopicName(userId, serverName, cohortName, topicName);
    }

    @DeleteMapping(path={"/cohorts/{cohortName}"})
    public VoidResponse clearCohortConfig(@PathVariable String userId, @PathVariable String serverName, @PathVariable String cohortName) {
        return this.adminAPI.clearCohortConfig(userId, serverName, cohortName);
    }

    @PostMapping(path={"/audit-log-destinations"})
    public VoidResponse setAuditLogDestinations(@PathVariable String userId, @PathVariable String serverName, @RequestBody List<Connection> auditLogDestinations) {
        return this.adminAPI.setAuditLogDestinations(userId, serverName, auditLogDestinations);
    }

    @GetMapping(path={"/audit-log-destinations"})
    public ConnectionListResponse getAuditLogDestinations(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.getAuditLogDestinations(userId, serverName);
    }

    @DeleteMapping(path={"/audit-log-destinations"})
    public VoidResponse clearAuditLogDestinations(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.clearAuditLogDestinations(userId, serverName);
    }

    @PostMapping(path={"/open-metadata-archives"})
    public VoidResponse setOpenMetadataArchives(@PathVariable String userId, @PathVariable String serverName, @RequestBody List<Connection> openMetadataArchives) {
        return this.adminAPI.setOpenMetadataArchives(userId, serverName, openMetadataArchives);
    }

    @GetMapping(path={"/open-metadata-archives"})
    public ConnectionListResponse getOpenMetadataArchives(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.getOpenMetadataArchives(userId, serverName);
    }

    @DeleteMapping(path={"/open-metadata-archives"})
    public VoidResponse clearOpenMetadataArchives(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.clearOpenMetadataArchives(userId, serverName);
    }

    @PostMapping(path={"/local-repository/configuration"})
    public VoidResponse setLocalRepositoryConfig(@PathVariable String userId, @PathVariable String serverName, @RequestBody LocalRepositoryConfig localRepositoryConfig) {
        return this.adminAPI.setLocalRepositoryConfig(userId, serverName, localRepositoryConfig);
    }

    @GetMapping(path={"/local-repository/configuration"})
    public LocalRepositoryConfigResponse getLocalRepositoryConfig(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.getLocalRepositoryConfig(userId, serverName);
    }

    @DeleteMapping(path={"/local-repository/configuration"})
    public VoidResponse clearLocalRepositoryConfig(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.clearLocalRepositoryConfig(userId, serverName);
    }

    @PostMapping(path={"/cohorts/{cohortName}/configuration"})
    public VoidResponse setCohortConfig(@PathVariable String userId, @PathVariable String serverName, @PathVariable String cohortName, @RequestBody CohortConfig cohortConfig) {
        return this.adminAPI.setCohortConfig(userId, serverName, cohortName, cohortConfig);
    }
}

