/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.adminservices.OMAGServerDataEngineProxyService;
import org.odpi.openmetadata.adminservices.configuration.properties.DataEngineProxyConfig;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/open-metadata/admin-services/users/{userId}/servers/{serverName}/data-engine-proxy-service"})
@Tag(name="Administration Services - Server Configuration", description="The server configuration administration services support the configuration of the open metadata and governance services within an OMAG Server. This configuration determines which of the Open Metadata and Governance (OMAG) services are active.", externalDocs=@ExternalDocumentation(description="Further information", url="https://odpi.github.io/egeria-docs/guides/admin/servers/"))
public class DataEngineProxyResource {
    private OMAGServerDataEngineProxyService adminAPI = new OMAGServerDataEngineProxyService();

    @PostMapping(path={"/configuration"})
    public VoidResponse setDataEngineProxyConfig(@PathVariable String userId, @PathVariable String serverName, @RequestBody DataEngineProxyConfig dataEngineProxyConfig) {
        return this.adminAPI.setDataEngineProxyConfig(userId, serverName, dataEngineProxyConfig);
    }

    @DeleteMapping(path={""})
    public VoidResponse deleteDataEngineProxy(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.deleteDataEngineProxy(userId, serverName);
    }
}

