/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adminservices.OMAGServerAdminForAccessServices;
import org.odpi.openmetadata.adminservices.configuration.properties.AccessServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.EnterpriseAccessConfig;
import org.odpi.openmetadata.adminservices.rest.AccessServiceConfigResponse;
import org.odpi.openmetadata.adminservices.rest.AccessServicesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.RegisteredOMAGServicesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.StringMapResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/open-metadata/admin-services/users/{userId}/servers/{serverName}"})
@Tag(name="Administration Services - Server Configuration", description="The server configuration administration services support the configuration of the open metadata and governance services within an OMAG Server. This configuration determines which of the Open Metadata and Governance (OMAG) services are active.", externalDocs=@ExternalDocumentation(description="Further information", url="https://odpi.github.io/egeria-docs/guides/admin/servers/"))
public class ConfigAccessServicesResource {
    private OMAGServerAdminForAccessServices adminAPI = new OMAGServerAdminForAccessServices();

    @GetMapping(path={"/access-services"})
    public RegisteredOMAGServicesResponse getConfiguredAccessServices(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.getConfiguredAccessServices(userId, serverName);
    }

    @GetMapping(path={"/access-services/configuration"})
    public AccessServicesResponse getAccessServicesConfiguration(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.getAccessServicesConfiguration(userId, serverName);
    }

    @PostMapping(path={"/access-services/{serviceURLMarker}"})
    public VoidResponse configureAccessService(@PathVariable String userId, @PathVariable String serverName, @PathVariable String serviceURLMarker, @RequestBody(required=false) Map<String, Object> accessServiceOptions) {
        return this.adminAPI.configureAccessService(userId, serverName, serviceURLMarker, accessServiceOptions);
    }

    @PostMapping(path={"/access-services"})
    public VoidResponse configureAllAccessServices(@PathVariable String userId, @PathVariable String serverName, @RequestBody(required=false) Map<String, Object> accessServiceOptions) {
        return this.adminAPI.configureAllAccessServices(userId, serverName, accessServiceOptions);
    }

    @PostMapping(path={"/access-services/{serviceURLMarker}/no-topics"})
    public VoidResponse configureAccessServiceNoTopics(@PathVariable String userId, @PathVariable String serverName, @PathVariable String serviceURLMarker, @RequestBody(required=false) Map<String, Object> accessServiceOptions) {
        return this.adminAPI.configureAccessServiceNoTopics(userId, serverName, serviceURLMarker, accessServiceOptions);
    }

    @PostMapping(path={"/access-services/no-topics"})
    public VoidResponse configureAllAccessServicesNoTopics(@PathVariable String userId, @PathVariable String serverName, @RequestBody(required=false) Map<String, Object> accessServiceOptions) {
        return this.adminAPI.configureAllAccessServicesNoTopics(userId, serverName, accessServiceOptions);
    }

    @DeleteMapping(path={"/access-services"})
    public VoidResponse clearAllAccessServices(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.clearAllAccessServices(userId, serverName);
    }

    @GetMapping(path={"/access-services/{serviceURLMarker}"})
    public AccessServiceConfigResponse getAccessServiceConfig(@PathVariable String userId, @PathVariable String serverName, @PathVariable String serviceURLMarker) {
        return this.adminAPI.getAccessServiceConfig(userId, serverName, serviceURLMarker);
    }

    @GetMapping(path={"/access-services/{serviceURLMarker}/topic-names"})
    public StringMapResponse getAccessServiceTopicNames(@PathVariable String userId, @PathVariable String serverName, @PathVariable String serviceURLMarker) {
        return this.adminAPI.getAccessServiceTopicNames(userId, serverName, serviceURLMarker);
    }

    @GetMapping(path={"/access-services/topic-names"})
    public StringMapResponse getAllAccessServiceTopicNames(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.getAllAccessServiceTopicNames(userId, serverName);
    }

    @PostMapping(path={"/access-services/{serviceURLMarker}/topic-names/in-topic"})
    public VoidResponse overrideAccessServiceInTopicName(@PathVariable String userId, @PathVariable String serverName, @PathVariable String serviceURLMarker, @RequestBody String topicName) {
        return this.adminAPI.overrideAccessServiceInTopicName(userId, serverName, serviceURLMarker, topicName);
    }

    @PostMapping(path={"/access-services/{serviceURLMarker}/topic-names/out-topic"})
    public VoidResponse overrideAccessServiceOutTopicName(@PathVariable String userId, @PathVariable String serverName, @PathVariable String serviceURLMarker, @RequestBody String topicName) {
        return this.adminAPI.overrideAccessServiceOutTopicName(userId, serverName, serviceURLMarker, topicName);
    }

    @DeleteMapping(path={"/access-services/{serviceURLMarker}"})
    public VoidResponse clearAccessService(@PathVariable String userId, @PathVariable String serverName, @PathVariable String serviceURLMarker) {
        return this.adminAPI.clearAccessService(userId, serverName, serviceURLMarker);
    }

    @PostMapping(path={"/access-services/configuration"})
    public VoidResponse setAccessServicesConfig(@PathVariable String userId, @PathVariable String serverName, @RequestBody List<AccessServiceConfig> accessServicesConfig) {
        return this.adminAPI.setAccessServicesConfig(userId, serverName, accessServicesConfig);
    }

    @PostMapping(path={"/enterprise-access/remote-topic"})
    public VoidResponse addRemoteEnterpriseTopic(@PathVariable String userId, @PathVariable String serverName, @RequestBody Map<String, Object> configurationProperties) {
        return this.adminAPI.addRemoteEnterpriseTopic(userId, serverName, configurationProperties);
    }

    @PostMapping(path={"/enterprise-access/configuration"})
    public VoidResponse setEnterpriseAccessConfig(@PathVariable String userId, @PathVariable String serverName, @RequestBody EnterpriseAccessConfig enterpriseAccessConfig) {
        return this.adminAPI.setEnterpriseAccessConfig(userId, serverName, enterpriseAccessConfig);
    }
}

