/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Map;
import org.odpi.openmetadata.adminservices.OMAGServerAdminServices;
import org.odpi.openmetadata.adminservices.rest.EventBusConfigResponse;
import org.odpi.openmetadata.adminservices.rest.URLRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/open-metadata/admin-services/users/{userId}/servers/{serverName}"})
@Tag(name="Administration Services - Server Configuration", description="The server configuration administration services support the configuration of the open metadata and governance services within an OMAG Server. This configuration determines which of the Open Metadata and Governance (OMAG) services are active.", externalDocs=@ExternalDocumentation(description="Further information", url="https://egeria-project.org/guides/admin/servers/"))
public class ConfigDefaultsResource {
    private OMAGServerAdminServices adminAPI = new OMAGServerAdminServices();

    @Deprecated
    @PostMapping(path={"/server-url-root"})
    public VoidResponse setServerURLRoot(@PathVariable String userId, @PathVariable String serverName, @RequestParam String url) {
        return this.adminAPI.setServerURLRoot(userId, serverName, url);
    }

    @PostMapping(path={"/server-url-root-for-caller"})
    public VoidResponse setServerRootURL(@PathVariable String userId, @PathVariable String serverName, @RequestBody URLRequestBody requestBody) {
        return this.adminAPI.setServerRootURL(userId, serverName, requestBody);
    }

    @PostMapping(path={"/event-bus"})
    public VoidResponse setEventBus(@PathVariable String userId, @PathVariable String serverName, @RequestParam(required=false) String connectorProvider, @RequestParam(required=false) String topicURLRoot, @RequestBody(required=false) Map<String, Object> configurationProperties) {
        return this.adminAPI.setEventBus(userId, serverName, connectorProvider, topicURLRoot, configurationProperties);
    }

    @GetMapping(path={"/event-bus"})
    public EventBusConfigResponse getEventBus(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.getEventBus(userId, serverName);
    }

    @DeleteMapping(path={"/event-bus"})
    public VoidResponse deleteEventBus(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.deleteEventBus(userId, serverName);
    }
}

