/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.odpi.openmetadata.adminservices.configuration.properties.IntegrationGroupConfig;
import org.odpi.openmetadata.adminservices.rest.IntegrationGroupsResponse;
import org.odpi.openmetadata.adminservices.server.OMAGServerAdminForIntegrationGroups;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/open-metadata/admin-services/users/{userId}/servers/{serverName}"})
@Tag(name="Administration Services - Server Configuration", description="The server configuration administration services support the configuration of the open metadata and governance services within an OMAG Server. This configuration determines which of the Open Metadata and Governance (OMAG) services are active.", externalDocs=@ExternalDocumentation(description="Further information", url="https://egeria-project.org/guides/admin/servers/"))
public class ConfigIntegrationGroupsResource {
    private final OMAGServerAdminForIntegrationGroups adminAPI = new OMAGServerAdminForIntegrationGroups();

    @GetMapping(value={"/integration-groups/configuration"})
    public IntegrationGroupsResponse getIntegrationGroupsConfiguration(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.getIntegrationGroupsConfiguration(userId, serverName);
    }

    @PostMapping(path={"/integration-groups/configuration"})
    public VoidResponse configureIntegrationGroup(@PathVariable String userId, @PathVariable String serverName, @RequestBody IntegrationGroupConfig groupConfig) {
        return this.adminAPI.configureIntegrationGroup(userId, serverName, groupConfig);
    }

    @PostMapping(path={"/integration-groups/configuration/all"})
    public VoidResponse setIntegrationGroupsConfig(@PathVariable String userId, @PathVariable String serverName, @RequestBody List<IntegrationGroupConfig> integrationGroupsConfig) {
        return this.adminAPI.setIntegrationGroupsConfig(userId, serverName, integrationGroupsConfig);
    }

    @DeleteMapping(path={"/integration-groups"})
    public VoidResponse clearAllIntegrationGroups(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.clearAllIntegrationGroups(userId, serverName);
    }

    @DeleteMapping(path={"/integration-groups/{groupQualifiedName}"})
    public VoidResponse clearIntegrationGroup(@PathVariable String userId, @PathVariable String serverName, @PathVariable String groupQualifiedName) {
        return this.adminAPI.clearIntegrationGroup(userId, serverName, groupQualifiedName);
    }
}

