/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adminservices.configuration.properties.AccessServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.EnterpriseAccessConfig;
import org.odpi.openmetadata.adminservices.rest.AccessServiceConfigResponse;
import org.odpi.openmetadata.adminservices.rest.AccessServicesResponse;
import org.odpi.openmetadata.adminservices.server.OMAGServerAdminForAccessServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.RegisteredOMAGServicesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.StringMapResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/open-metadata/admin-services/users/{userId}/servers/{serverName}"})
@Tag(name="Administration Services - Server Configuration", description="The server configuration administration services support the configuration of the open metadata and governance services within an OMAG Server. This configuration determines which of the Open Metadata and Governance (OMAG) services are active.", externalDocs=@ExternalDocumentation(description="Further information", url="https://egeria-project.org/guides/admin/servers/"))
public class ConfigAccessServicesResource {
    private final OMAGServerAdminForAccessServices adminAPI = new OMAGServerAdminForAccessServices();

    @GetMapping(path={"/access-services"})
    @Operation(summary="getConfiguredAccessServices", description="Return the list of access services that are configured for this server.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omas/"))
    public RegisteredOMAGServicesResponse getConfiguredAccessServices(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.getConfiguredAccessServices(userId, serverName);
    }

    @GetMapping(path={"/access-services/configuration"})
    @Operation(summary="getAccessServicesConfiguration", description="Return the detailed configuration for the access services in this server.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omas/"))
    public AccessServicesResponse getAccessServicesConfiguration(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.getAccessServicesConfiguration(userId, serverName);
    }

    @PostMapping(path={"/access-services/{serviceURLMarker}"})
    @Operation(summary="configureAccessService", description="Enable a single access service.  This access service will send notifications if it is part of its implementation.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omas/"))
    public VoidResponse configureAccessService(@PathVariable String userId, @PathVariable String serverName, @PathVariable String serviceURLMarker, @RequestBody(required=false) Map<String, Object> accessServiceOptions) {
        return this.adminAPI.configureAccessService(userId, serverName, serviceURLMarker, accessServiceOptions);
    }

    @PostMapping(path={"/access-services"})
    @Operation(summary="configureAllAccessServices", description="Enable all access services that are registered with this server platform.  The access services will send notifications if it is part of its implementation.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omas/"))
    public VoidResponse configureAllAccessServices(@PathVariable String userId, @PathVariable String serverName, @RequestBody(required=false) Map<String, Object> accessServiceOptions) {
        return this.adminAPI.configureAllAccessServices(userId, serverName, accessServiceOptions);
    }

    @PostMapping(path={"/access-services/{serviceURLMarker}/no-topics"})
    @Operation(summary="configureAccessServiceNoTopics", description="Enable a single access service.  Notifications, if supported, are disabled.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omas/"))
    public VoidResponse configureAccessServiceNoTopics(@PathVariable String userId, @PathVariable String serverName, @PathVariable String serviceURLMarker, @RequestBody(required=false) Map<String, Object> accessServiceOptions) {
        return this.adminAPI.configureAccessServiceNoTopics(userId, serverName, serviceURLMarker, accessServiceOptions);
    }

    @PostMapping(path={"/access-services/no-topics"})
    @Operation(summary="configureAllAccessServicesNoTopics", description="Enable all access services that are registered with this server platform.  Notifications, if supported, are disabled.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omas/"))
    public VoidResponse configureAllAccessServicesNoTopics(@PathVariable String userId, @PathVariable String serverName, @RequestBody(required=false) Map<String, Object> accessServiceOptions) {
        return this.adminAPI.configureAllAccessServicesNoTopics(userId, serverName, accessServiceOptions);
    }

    @DeleteMapping(path={"/access-services"})
    @Operation(summary="clearAllAccessServices", description="Disable the access services.  This removes all configuration for the access services and disables the enterprise repository services.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omas/"))
    public VoidResponse clearAllAccessServices(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.clearAllAccessServices(userId, serverName);
    }

    @GetMapping(path={"/access-services/{serviceURLMarker}"})
    @Operation(summary="getAccessServiceConfig", description="Retrieve the config for an access service.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omas/"))
    public AccessServiceConfigResponse getAccessServiceConfig(@PathVariable String userId, @PathVariable String serverName, @PathVariable String serviceURLMarker) {
        return this.adminAPI.getAccessServiceConfig(userId, serverName, serviceURLMarker);
    }

    @GetMapping(path={"/access-services/{serviceURLMarker}/topic-names"})
    @Operation(summary="getAccessServiceTopicNames", description="Retrieve the topic names for this access service.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omas/"))
    public StringMapResponse getAccessServiceTopicNames(@PathVariable String userId, @PathVariable String serverName, @PathVariable String serviceURLMarker) {
        return this.adminAPI.getAccessServiceTopicNames(userId, serverName, serviceURLMarker);
    }

    @GetMapping(path={"/access-services/topic-names"})
    @Operation(summary="getAllAccessServiceTopicNames", description="Retrieve the topic names for all access services.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omas/"))
    public StringMapResponse getAllAccessServiceTopicNames(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.getAllAccessServiceTopicNames(userId, serverName);
    }

    @PostMapping(path={"/access-services/{serviceURLMarker}/topic-names/in-topic"})
    @Operation(summary="overrideAccessServiceInTopicName", description="Update the in topic name for a specific access service.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omas/"))
    public VoidResponse overrideAccessServiceInTopicName(@PathVariable String userId, @PathVariable String serverName, @PathVariable String serviceURLMarker, @RequestBody String topicName) {
        return this.adminAPI.overrideAccessServiceInTopicName(userId, serverName, serviceURLMarker, topicName);
    }

    @PostMapping(path={"/access-services/{serviceURLMarker}/topic-names/out-topic"})
    @Operation(summary="overrideAccessServiceOutTopicName", description="Update the out topic name for a specific access service.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omas/"))
    public VoidResponse overrideAccessServiceOutTopicName(@PathVariable String userId, @PathVariable String serverName, @PathVariable String serviceURLMarker, @RequestBody String topicName) {
        return this.adminAPI.overrideAccessServiceOutTopicName(userId, serverName, serviceURLMarker, topicName);
    }

    @DeleteMapping(path={"/access-services/{serviceURLMarker}"})
    @Operation(summary="clearAccessService", description="Remove the config for an access service.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omas/"))
    public VoidResponse clearAccessService(@PathVariable String userId, @PathVariable String serverName, @PathVariable String serviceURLMarker) {
        return this.adminAPI.clearAccessService(userId, serverName, serviceURLMarker);
    }

    @PostMapping(path={"/access-services/configuration"})
    @Operation(summary="setAccessServicesConfig", description="Set up the configuration for selected open metadata access services (OMASs).  This overrides the current configured values.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omas/"))
    public VoidResponse setAccessServicesConfig(@PathVariable String userId, @PathVariable String serverName, @RequestBody List<AccessServiceConfig> accessServicesConfig) {
        return this.adminAPI.setAccessServicesConfig(userId, serverName, accessServicesConfig);
    }

    @PostMapping(path={"/enterprise-access/remote-topic"})
    @Operation(summary="addRemoteEnterpriseTopic", description="Set up the default remote enterprise topic.  This allows a remote process to monitor enterprise topic events.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omas/"))
    public VoidResponse addRemoteEnterpriseTopic(@PathVariable String userId, @PathVariable String serverName, @RequestBody Map<String, Object> configurationProperties) {
        return this.adminAPI.addRemoteEnterpriseTopic(userId, serverName, configurationProperties);
    }

    @PostMapping(path={"/enterprise-access/configuration"})
    @Operation(summary="setEnterpriseAccessConfig", description="Set up the configuration that controls the enterprise repository services.  These services are part of the Open Metadata Repository Services (OMRS).  They provide federated queries and federated event notifications that cover metadata from the local repository plus any repositories connected via open metadata repository cohorts.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omas/"))
    public VoidResponse setEnterpriseAccessConfig(@PathVariable String userId, @PathVariable String serverName, @RequestBody EnterpriseAccessConfig enterpriseAccessConfig) {
        return this.adminAPI.setEnterpriseAccessConfig(userId, serverName, enterpriseAccessConfig);
    }
}

