/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.odpi.openmetadata.adminservices.configuration.properties.IntegrationDaemonServicesConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.IntegrationGroupConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.IntegrationServiceConfig;
import org.odpi.openmetadata.adminservices.rest.IntegrationDaemonServicesResponse;
import org.odpi.openmetadata.adminservices.rest.IntegrationGroupsResponse;
import org.odpi.openmetadata.adminservices.rest.IntegrationServiceConfigResponse;
import org.odpi.openmetadata.adminservices.rest.IntegrationServiceRequestBody;
import org.odpi.openmetadata.adminservices.rest.IntegrationServicesResponse;
import org.odpi.openmetadata.adminservices.server.OMAGServerAdminForIntegrationDaemonServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.RegisteredOMAGServicesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/open-metadata/admin-services/users/{userId}/servers/{serverName}"})
@Tag(name="Administration Services - Server Configuration", description="The server configuration administration services support the configuration of the open metadata and governance services within an OMAG Server. This configuration determines which of the Open Metadata and Governance (OMAG) services are active.", externalDocs=@ExternalDocumentation(description="Further information", url="https://egeria-project.org/guides/admin/servers/"))
public class ConfigIntegrationDaemonServicesResource {
    private final OMAGServerAdminForIntegrationDaemonServices adminAPI = new OMAGServerAdminForIntegrationDaemonServices();

    @GetMapping(value={"/integration-groups/configuration"})
    @Operation(summary="getIntegrationGroupsConfiguration", description="Return the integration groups configuration for this server.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-group/"))
    public IntegrationGroupsResponse getIntegrationGroupsConfiguration(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.getIntegrationGroupsConfiguration(userId, serverName);
    }

    @PostMapping(path={"/integration-groups/configuration"})
    @Operation(summary="configureIntegrationGroup", description="Add configuration for a single integration group to the server's config document.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-group/"))
    public VoidResponse configureIntegrationGroup(@PathVariable String userId, @PathVariable String serverName, @RequestBody IntegrationGroupConfig groupConfig) {
        return this.adminAPI.configureIntegrationGroup(userId, serverName, groupConfig);
    }

    @PostMapping(path={"/integration-groups/configuration/all"})
    @Operation(summary="setIntegrationGroupsConfig", description="Set up the configuration for all the open metadata integration groups.  This overrides the current values.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-group/"))
    public VoidResponse setIntegrationGroupsConfig(@PathVariable String userId, @PathVariable String serverName, @RequestBody List<IntegrationGroupConfig> integrationGroupsConfig) {
        return this.adminAPI.setIntegrationGroupsConfig(userId, serverName, integrationGroupsConfig);
    }

    @DeleteMapping(path={"/integration-groups"})
    @Operation(summary="clearAllIntegrationGroups", description="Disable the integration groups.  This removes all configuration for the integration groups from the integration daemon.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-group/"))
    public VoidResponse clearAllIntegrationGroups(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.clearAllIntegrationGroups(userId, serverName);
    }

    @DeleteMapping(path={"/integration-groups/{groupQualifiedName}"})
    @Operation(summary="clearIntegrationGroup", description="Remove an integration group.  This removes all configuration for the integration group.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-group/"))
    public VoidResponse clearIntegrationGroup(@PathVariable String userId, @PathVariable String serverName, @PathVariable String groupQualifiedName) {
        return this.adminAPI.clearIntegrationGroup(userId, serverName, groupQualifiedName);
    }

    @GetMapping(value={"/integration-services"})
    @Operation(summary="getRegisteredIntegrationServices", description="Return the list of registered integration services for this server.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omis/"))
    public RegisteredOMAGServicesResponse getRegisteredIntegrationServices(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.getRegisteredIntegrationServices(userId, serverName);
    }

    @GetMapping(value={"/integration-services/configuration"})
    @Operation(summary="getIntegrationServicesConfiguration", description="Return the integration services configuration for this server.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omis/"))
    public IntegrationServicesResponse getIntegrationServicesConfiguration(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.getIntegrationServicesConfiguration(userId, serverName);
    }

    @GetMapping(value={"/integration-services/{serviceURLMarker}/configuration"})
    @Operation(summary="getIntegrationServiceConfiguration", description="Return the configuration for the named integration service for this server.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omis/"))
    public IntegrationServiceConfigResponse getIntegrationServiceConfiguration(@PathVariable String userId, @PathVariable String serverName, @PathVariable String serviceURLMarker) {
        return this.adminAPI.getIntegrationServiceConfiguration(userId, serverName, serviceURLMarker);
    }

    @PostMapping(path={"/integration-services/{serviceURLMarker}"})
    @Operation(summary="configureIntegrationService", description="Enable a single registered integration service.  This builds the integration service configuration for the server's config document.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omis/"))
    public VoidResponse configureIntegrationService(@PathVariable String userId, @PathVariable String serverName, @PathVariable String serviceURLMarker, @RequestBody IntegrationServiceRequestBody requestBody) {
        return this.adminAPI.configureIntegrationService(userId, serverName, serviceURLMarker, requestBody);
    }

    @PostMapping(path={"/integration-services"})
    @Operation(summary="configureAllIntegrationServices", description="Enable all non-deprecated, registered integration services.  This builds the integration service configuration for the server's config document.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omis/"))
    public VoidResponse configureAllIntegrationServices(@PathVariable String userId, @PathVariable String serverName, @RequestBody IntegrationServiceRequestBody requestBody) {
        return this.adminAPI.configureAllIntegrationServices(userId, serverName, requestBody);
    }

    @PostMapping(path={"/integration-services/configuration"})
    @Operation(summary="configureIntegrationService", description="Add configuration for a single integration service to the server's config document.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omis/"))
    public VoidResponse configureIntegrationService(@PathVariable String userId, @PathVariable String serverName, @RequestBody IntegrationServiceConfig serviceConfig) {
        return this.adminAPI.configureIntegrationService(userId, serverName, serviceConfig);
    }

    @PostMapping(path={"/integration-services/configuration/all"})
    @Operation(summary="setIntegrationServicesConfig", description="Set up the configuration for all the open metadata integration services (OMISs).  This overrides the current values.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omis/"))
    public VoidResponse setIntegrationServicesConfig(@PathVariable String userId, @PathVariable String serverName, @RequestBody List<IntegrationServiceConfig> integrationServicesConfig) {
        return this.adminAPI.setIntegrationServicesConfig(userId, serverName, integrationServicesConfig);
    }

    @DeleteMapping(path={"/integration-services"})
    @Operation(summary="clearAllIntegrationServices", description="Disable the integration services.  This removes all configuration for the integration services from the integration daemon.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omis/"))
    public VoidResponse clearAllIntegrationServices(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.clearAllIntegrationServices(userId, serverName);
    }

    @DeleteMapping(path={"/integration-services/{serviceURLMarker}"})
    @Operation(summary="clearIntegrationService", description="Remove an integration service.  This removes all configuration for the integration service.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omis/"))
    public VoidResponse clearIntegrationService(@PathVariable String userId, @PathVariable String serverName, @PathVariable String serviceURLMarker) {
        return this.adminAPI.clearIntegrationService(userId, serverName, serviceURLMarker);
    }

    @GetMapping(value={"/integration-daemon-services"})
    @Operation(summary="getIntegrationDaemonServicesConfiguration", description="Return the configuration of the specialist services for an Integration Daemon OMAG Server.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-daemon/"))
    public IntegrationDaemonServicesResponse getIntegrationDaemonServicesConfiguration(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.getIntegrationDaemonServicesConfiguration(userId, serverName);
    }

    @PostMapping(path={"/integration-daemon-services"})
    @Operation(summary="setIntegrationDaemonServicesConfig", description="Set up the configuration of the specialist services for an Integration Daemon OMAG Server in a single call.  This overrides the current values.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-daemon/"))
    public VoidResponse setIntegrationDaemonServicesConfig(@PathVariable String userId, @PathVariable String serverName, @RequestBody IntegrationDaemonServicesConfig servicesConfig) {
        return this.adminAPI.setIntegrationDaemonServicesConfig(userId, serverName, servicesConfig);
    }

    @DeleteMapping(path={"/integration-daemon-services"})
    @Operation(summary="clearIntegrationDaemonServicesConfig", description="Remove the specialist services for an Integration Daemon OMAG Server in a single call.  This overrides the current values.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-daemon/"))
    public VoidResponse clearIntegrationDaemonServicesConfig(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.clearIntegrationDaemonServicesConfig(userId, serverName);
    }
}

