/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Map;
import org.odpi.openmetadata.adminservices.rest.EventBusConfigResponse;
import org.odpi.openmetadata.adminservices.rest.URLRequestBody;
import org.odpi.openmetadata.adminservices.server.OMAGServerAdminServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/open-metadata/admin-services/users/{userId}/servers/{serverName}"})
@Tag(name="Administration Services - Server Configuration", description="The server configuration administration services support the configuration of the open metadata and governance services within an OMAG Server. This configuration determines which of the Open Metadata and Governance (OMAG) services are active.", externalDocs=@ExternalDocumentation(description="Further information", url="https://egeria-project.org/guides/admin/servers/"))
public class ConfigDefaultsResource {
    private final OMAGServerAdminServices adminAPI = new OMAGServerAdminServices();

    @Deprecated
    @PostMapping(path={"/server-url-root"})
    @Operation(summary="setServerURLRoot", description="Set up the default root URL for this server that is used to construct full URL paths to calls for this server's REST interfaces.  It is a value that is sent to other servers to allow them to call this server. The default value is \"localhost:9443\". ServerURLRoot is used as a default value during the configuration of the server's subsystems. If it is updated after a subsystem is configured then the new value is ignored.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/guides/admin/servers/configuring-a-metadata-access-store/#set-the-server-url-root"))
    public VoidResponse setServerURLRoot(@PathVariable String userId, @PathVariable String serverName, @RequestParam String url) {
        return this.adminAPI.setServerURLRoot(userId, serverName, url);
    }

    @PostMapping(path={"/server-url-root-for-caller"})
    @Operation(summary="setServerRootURL", description="Set up the default root URL for this server that is used to construct full URL paths to calls for this server's REST interfaces.  It is a value that is sent to other servers to allow them to call this server. The default value is \"https://localhost:9443\". ServerURLRoot is used as a default value during the configuration of the server's subsystems. If it is updated after a subsystem is configured then the new value is ignored.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/guides/admin/servers/configuring-a-metadata-access-store/#set-the-server-url-root"))
    public VoidResponse setServerRootURL(@PathVariable String userId, @PathVariable String serverName, @RequestBody URLRequestBody requestBody) {
        return this.adminAPI.setServerRootURL(userId, serverName, requestBody);
    }

    @PostMapping(path={"/event-bus"})
    @Operation(summary="setEventBus", description="Set up the default event bus for embedding in event-driven connector.   The resulting connector will be used for example, in the OMRS Topic Connector for each cohort, the in and out topics for each Access Service and possibly the local repository's event mapper. When the event bus is configured, it is used only on future configuration.  It does not effect existing configuration.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/guides/admin/servers/configuring-a-metadata-access-store/#set-up-the-default-event-bus"))
    public VoidResponse setEventBus(@PathVariable String userId, @PathVariable String serverName, @RequestParam(required=false) String connectorProvider, @RequestParam(required=false) String topicURLRoot, @RequestBody(required=false) Map<String, Object> configurationProperties) {
        return this.adminAPI.setEventBus(userId, serverName, connectorProvider, topicURLRoot, configurationProperties);
    }

    @GetMapping(path={"/event-bus"})
    @Operation(summary="getEventBus", description="Return the current configuration for the event bus.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/guides/admin/servers/configuring-a-metadata-access-store/#set-up-the-default-event-bus"))
    public EventBusConfigResponse getEventBus(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.getEventBus(userId, serverName);
    }

    @DeleteMapping(path={"/event-bus"})
    @Operation(summary="deleteEventBus", description="Delete the current configuration for the event bus.  This does not impact that existing configuration for the server, only future configuration requests.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/guides/admin/servers/configuring-a-metadata-access-store/#set-up-the-default-event-bus"))
    public VoidResponse deleteEventBus(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.deleteEventBus(userId, serverName);
    }
}

