/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.odpi.openmetadata.adminservices.configuration.properties.EngineConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.EngineHostServicesConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.EngineServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerClientConfig;
import org.odpi.openmetadata.adminservices.rest.EngineHostServicesResponse;
import org.odpi.openmetadata.adminservices.rest.EngineServiceConfigResponse;
import org.odpi.openmetadata.adminservices.rest.EngineServiceRequestBody;
import org.odpi.openmetadata.adminservices.server.OMAGServerAdminForEngineHostServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.RegisteredOMAGServicesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/open-metadata/admin-services/users/{userId}/servers/{serverName}"})
@Tag(name="Administration Services - Server Configuration", description="The server configuration administration services support the configuration of the open metadata and governance services within an OMAG Server. This configuration determines which of the Open Metadata and Governance (OMAG) services are active.", externalDocs=@ExternalDocumentation(description="Further information", url="https://egeria-project.org/guides/admin/servers/"))
public class ConfigEngineHostServicesResource {
    private final OMAGServerAdminForEngineHostServices adminAPI = new OMAGServerAdminForEngineHostServices();

    @GetMapping(value={"/engine-services"})
    @Operation(summary="getConfiguredEngineServices", description="Return the list of registered engine services for this server.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omes/"))
    public RegisteredOMAGServicesResponse getConfiguredEngineServices(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.getConfiguredEngineServices(userId, serverName);
    }

    @GetMapping(value={"/engine-services/{serviceURLMarker}/configuration"})
    @Operation(summary="getEngineServiceConfiguration", description="Return the configuration for the named engine service for this server.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omes/"))
    public EngineServiceConfigResponse getEngineServiceConfiguration(@PathVariable String userId, @PathVariable String serverName, @PathVariable String serviceURLMarker) {
        return this.adminAPI.getEngineServiceConfiguration(userId, serverName, serviceURLMarker);
    }

    @PostMapping(value={"/engine-definitions/client-config"})
    @Operation(summary="setEngineDefinitionsClientConfig", description="Set up the name and platform URL root for the metadata server running the Governance Engine OMAS that provides the governance engine definitions used by the engine services.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omes/"))
    public VoidResponse setEngineDefinitionsClientConfig(@PathVariable String userId, @PathVariable String serverName, @RequestBody OMAGServerClientConfig clientConfig) {
        return this.adminAPI.setEngineDefinitionsClientConfig(userId, serverName, clientConfig);
    }

    @PostMapping(value={"/engine-list"})
    @Operation(summary="setEngineList", description="Set up the list of governance engine that will use the metadata from the same metadata access server as the engine host uses for retrieving the engine configuration.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-engine/"))
    public VoidResponse setEngineList(@PathVariable String userId, @PathVariable String serverName, @RequestBody List<EngineConfig> engines) {
        return this.adminAPI.setEngineList(userId, serverName, engines);
    }

    @PostMapping(value={"/engine"})
    @Operation(summary="addEngine", description="Add another engine the list of governance engine that will use the metadata from the same metadata access server as the engine host uses for retrieving the engine configuration.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-engine/"))
    public VoidResponse addEngine(@PathVariable String userId, @PathVariable String serverName, @RequestBody EngineConfig engine) {
        return this.adminAPI.addEngine(userId, serverName, engine);
    }

    @PostMapping(path={"/engine-services/{serviceURLMarker}"})
    @Operation(summary="configureEngineService", description="Enable a single registered engine service.  This builds the engine service configuration for the server's config document.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omes/"))
    public VoidResponse configureEngineService(@PathVariable String userId, @PathVariable String serverName, @PathVariable String serviceURLMarker, @RequestBody EngineServiceRequestBody requestBody) {
        return this.adminAPI.configureEngineService(userId, serverName, serviceURLMarker, requestBody);
    }

    @PostMapping(path={"/engine-services"})
    @Operation(summary="configureAllEngineServices", description="Enable all non-deprecated, registered engine service.  This builds the engine service configuration for the server's config document.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omes/"))
    public VoidResponse configureAllEngineServices(@PathVariable String userId, @PathVariable String serverName, @RequestBody EngineServiceRequestBody requestBody) {
        return this.adminAPI.configureAllEngineServices(userId, serverName, requestBody);
    }

    @PostMapping(path={"/engine-services/configuration"})
    @Operation(summary="configureEngineService", description="Add configuration for a single engine service to the server's config document.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omes/"))
    public VoidResponse configureEngineService(@PathVariable String userId, @PathVariable String serverName, @RequestBody EngineServiceConfig serviceConfig) {
        return this.adminAPI.configureEngineService(userId, serverName, serviceConfig);
    }

    @PostMapping(path={"/engine-services/configuration/all"})
    @Operation(summary="setEngineServicesConfig", description="Set up the configuration for all the open metadata engine services (OMESs).  This overrides the current values.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omes/"))
    public VoidResponse setEngineServicesConfig(@PathVariable String userId, @PathVariable String serverName, @RequestBody List<EngineServiceConfig> engineServicesConfig) {
        return this.adminAPI.setEngineServicesConfig(userId, serverName, engineServicesConfig);
    }

    @DeleteMapping(path={"/engine-definitions/client-config"})
    @Operation(summary="clearEngineDefinitionsClientConfig", description="Remove the configuration for the Governance Engine OMAS Engine client configuration in a single call.  This overrides the current values.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omes/"))
    public VoidResponse clearEngineDefinitionsClientConfig(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.clearEngineDefinitionsClientConfig(userId, serverName);
    }

    @DeleteMapping(path={"/engine-list"})
    @Operation(summary="clearEngineList", description="Remove the configuration for the engine list in a single call.  This overrides the current values.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-engine/"))
    public VoidResponse clearEngineList(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.clearEngineList(userId, serverName);
    }

    @DeleteMapping(path={"/engine-services"})
    @Operation(summary="clearAllEngineServices", description="Disable the engine services.  This removes all configuration for the engine services in the engine host.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omes/"))
    public VoidResponse clearAllEngineServices(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.clearAllEngineServices(userId, serverName);
    }

    @DeleteMapping(path={"/engine-services/{serviceURLMarker}"})
    @Operation(summary="clearEngineService", description="Remove an engine service.  This removes all configuration for the engine service.  Other configured engine services are untouched.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omes/"))
    public VoidResponse clearEngineService(@PathVariable String userId, @PathVariable String serverName, @PathVariable String serviceURLMarker) {
        return this.adminAPI.clearEngineService(userId, serverName, serviceURLMarker);
    }

    @GetMapping(value={"/engine-host-services/configuration", "/engine-host-services"})
    @Operation(summary="getEngineHostServicesConfiguration", description="Return the configuration of the specialist services for an Engine Host OMAG Server.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/engine-host/"))
    public EngineHostServicesResponse getEngineHostServicesConfiguration(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.getEngineHostServicesConfiguration(userId, serverName);
    }

    @PostMapping(path={"/engine-host-services"})
    @Operation(summary="setEngineHostServicesConfig", description="Set up the configuration of the specialist services for an Engine Host OMAG Server in a single call.  This overrides the current values.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/engine-host/"))
    public VoidResponse setEngineHostServicesConfig(@PathVariable String userId, @PathVariable String serverName, @RequestBody EngineHostServicesConfig servicesConfig) {
        return this.adminAPI.setEngineHostServicesConfig(userId, serverName, servicesConfig);
    }

    @DeleteMapping(path={"/engine-host-services"})
    @Operation(summary="clearEngineHostServicesConfig", description="Remove the specialist services for an Engine Host OMAG Server in a single call.  This overrides the current values.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/engine-host/"))
    public VoidResponse clearEngineHostServicesConfig(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.clearEngineHostServicesConfig(userId, serverName);
    }
}

