/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.adminservices.rest.ConnectionResponse;
import org.odpi.openmetadata.adminservices.server.OMAGServerAdminSecurityServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/open-metadata/admin-services/users/{userId}/servers/{serverName}/security"})
@Tag(name="Administration Services - Server Configuration", description="The server configuration administration services support the configuration of the open metadata and governance services within an OMAG Server. This configuration determines which of the Open Metadata and Governance (OMAG) services are active.", externalDocs=@ExternalDocumentation(description="Further information", url="https://egeria-project.org/guides/admin/servers/"))
public class ConfigOpenMetadataServerSecurityResource {
    private final OMAGServerAdminSecurityServices adminSecurityAPI = new OMAGServerAdminSecurityServices();

    @PostMapping(path={"/connection"})
    @Operation(summary="setServerSecurityConnection", description="Override the existing server security connector.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/server-metadata-security-connector/"))
    public synchronized VoidResponse setServerSecurityConnection(@PathVariable String userId, @PathVariable String serverName, @RequestBody Connection connection) {
        return this.adminSecurityAPI.setServerSecurityConnection(userId, serverName, connection);
    }

    @GetMapping(path={"/connection"})
    @Operation(summary="getServerSecurityConnection", description="Return the connection object for the server security connector.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/server-metadata-security-connector/"))
    public synchronized ConnectionResponse getServerSecurityConnection(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminSecurityAPI.getServerSecurityConnection(userId, serverName);
    }

    @DeleteMapping(path={"/connection"})
    @Operation(summary="clearServerSecurityConnection", description="Clear the connection object for the server security connector. This sets the server security back to default of no authorization security.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/server-metadata-security-connector/"))
    public synchronized VoidResponse clearServerSecurityConnection(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminSecurityAPI.clearServerSecurityConnection(userId, serverName);
    }
}

