/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.adminservices.rest.BasicServerPropertiesResponse;
import org.odpi.openmetadata.adminservices.rest.ServerPropertiesRequestBody;
import org.odpi.openmetadata.adminservices.rest.ServerTypeClassificationResponse;
import org.odpi.openmetadata.adminservices.server.OMAGServerAdminServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/open-metadata/admin-services/users/{userId}/servers/{serverName}"})
@Tag(name="Administration Services - Server Configuration", description="The server configuration administration services support the configuration of the open metadata and governance services within an OMAG Server. This configuration determines which of the Open Metadata and Governance (OMAG) services are active.", externalDocs=@ExternalDocumentation(description="Further information", url="https://egeria-project.org/guides/admin/servers/"))
public class ConfigPropertiesResource {
    private final OMAGServerAdminServices adminAPI = new OMAGServerAdminServices();

    @GetMapping(path={"/server-type-classification"})
    @Operation(summary="getServerTypeClassification", description="Return the derived server type that is created from the classification of the server configuration.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/omag-server/#types-of-omag-server"))
    public ServerTypeClassificationResponse getServerTypeClassification(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.getServerTypeClassification(userId, serverName);
    }

    @PostMapping(path={"/server-type"})
    @Operation(summary="setDescriptiveServerType", description="Set up the descriptive type of the server.  This value is added to distributed events to make it easier to understand the source of events.  The default value is null which means the server classification is used.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/omag-server/#types-of-omag-server"))
    @Deprecated
    public VoidResponse setServerType(@PathVariable String userId, @PathVariable String serverName, @RequestParam String typeName) {
        return this.adminAPI.setServerType(userId, serverName, typeName);
    }

    @PostMapping(path={"/organization-name"})
    @Operation(summary="setOrganizationName", description="Set up the name of the organization that is running this server.  This value is added to distributed events to make it easier to understand the source of events.  The default value is null.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/omag-server/"))
    public VoidResponse setOrganizationName(@PathVariable String userId, @PathVariable String serverName, @RequestParam String name) {
        return this.adminAPI.setOrganizationName(userId, serverName, name);
    }

    @PostMapping(path={"/server-description"})
    @Operation(summary="setServerDescription", description="Set up the description of this server. The default value is null.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/omag-server/"))
    public VoidResponse setServerDescription(@PathVariable String userId, @PathVariable String serverName, @RequestBody String description) {
        return this.adminAPI.setServerDescription(userId, serverName, description);
    }

    @PostMapping(path={"/server-user-id"})
    @Operation(summary="setServerUserId", description="Set up the description of this server. The default value is null.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/omag-server/"))
    public VoidResponse setServerUserId(@PathVariable String userId, @PathVariable String serverName, @RequestParam String id) {
        return this.adminAPI.setServerUserId(userId, serverName, id);
    }

    @PostMapping(path={"/server-user-password"})
    @Operation(summary="setServerPassword", description="Set up the password to use when the server is issuing REST calls.  If this value is set then the serverUserId and this password are both embedded in the HTTP header.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/omag-server/"))
    public VoidResponse setServerPassword(@PathVariable String userId, @PathVariable String serverName, @RequestParam String password) {
        return this.adminAPI.setServerPassword(userId, serverName, password);
    }

    @PostMapping(path={"/max-page-size"})
    @Operation(summary="setMaxPageSize", description="Set an upper limit in the page size that can be requested on a REST call to the server.  The default value is 1000.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/omag-server/"))
    public VoidResponse setMaxPageSize(@PathVariable String userId, @PathVariable String serverName, @RequestParam int limit) {
        return this.adminAPI.setMaxPageSize(userId, serverName, limit);
    }

    @PostMapping(path={"/server-properties"})
    @Operation(summary="setBasicServerProperties", description="Set up the basic server properties in a single request.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/omag-server/"))
    public VoidResponse setBasicServerProperties(@PathVariable String userId, @PathVariable String serverName, @RequestBody ServerPropertiesRequestBody requestBody) {
        return this.adminAPI.setBasicServerProperties(userId, serverName, requestBody);
    }

    @GetMapping(path={"/server-properties"})
    @Operation(summary="getBasicServerProperties", description="Return the basic server properties in a single request.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/omag-server/"))
    public BasicServerPropertiesResponse getBasicServerProperties(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.getBasicServerProperties(userId, serverName);
    }
}

