/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.rest.OMAGServerConfigResponse;
import org.odpi.openmetadata.adminservices.rest.URLRequestBody;
import org.odpi.openmetadata.adminservices.server.OMAGServerAdminServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/open-metadata/admin-services/users/{userId}/servers/{serverName}"})
@Tag(name="Administration Services - Server Configuration", description="The server configuration administration services support the configuration of the open metadata and governance services within an OMAG Server. This configuration determines which of the Open Metadata and Governance (OMAG) services are active.", externalDocs=@ExternalDocumentation(description="Further information", url="https://egeria-project.org/guides/admin/servers/"))
public class ConfigResource {
    private final OMAGServerAdminServices adminAPI = new OMAGServerAdminServices();

    @GetMapping(path={"/configuration"})
    @Operation(summary="getStoredConfiguration", description="Return the stored configuration document for the server.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/configuration-document/"))
    public OMAGServerConfigResponse getStoredConfiguration(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.getStoredConfiguration(userId, serverName);
    }

    @PostMapping(path={"/configuration"})
    @Operation(summary="setOMAGServerConfig", description="Set up the configuration properties for an OMAG Server in a single command.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/configuration-document/"))
    public VoidResponse setOMAGServerConfig(@PathVariable String userId, @PathVariable String serverName, @RequestBody OMAGServerConfig omagServerConfig) {
        return this.adminAPI.setOMAGServerConfig(userId, serverName, omagServerConfig);
    }

    @DeleteMapping(path={"/configuration"})
    @Operation(summary="clearOMAGServerConfig", description="Clear the configuration properties for an OMAG Server in a single command.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/configuration-document/"))
    public VoidResponse clearOMAGServerConfig(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.clearOMAGServerConfig(userId, serverName);
    }

    @PostMapping(path={"/configuration/deploy"})
    @Operation(summary="deployOMAGServerConfig", description="Push the configuration for the server to another OMAG Server Platform.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/configuration-document/"))
    public VoidResponse deployOMAGServerConfig(@PathVariable String userId, @PathVariable String serverName, @RequestBody URLRequestBody destinationPlatform) {
        return this.adminAPI.deployOMAGServerConfig(userId, serverName, destinationPlatform);
    }
}

