/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.odpi.openmetadata.adminservices.configuration.properties.ViewServiceConfig;
import org.odpi.openmetadata.adminservices.rest.ViewServiceConfigResponse;
import org.odpi.openmetadata.adminservices.rest.ViewServiceRequestBody;
import org.odpi.openmetadata.adminservices.rest.ViewServicesResponse;
import org.odpi.openmetadata.adminservices.server.OMAGServerAdminForViewServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.RegisteredOMAGServicesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/open-metadata/admin-services/users/{userId}/servers/{serverName}"})
@Tag(name="Administration Services - Server Configuration", description="The server configuration administration services support the configuration of the open metadata and governance services within an OMAG Server. This configuration determines which of the Open Metadata and Governance (OMAG) services are active.", externalDocs=@ExternalDocumentation(description="Further information", url="https://egeria-project.org/guides/admin/servers/"))
public class ConfigViewServicesResource {
    private final OMAGServerAdminForViewServices adminAPI = new OMAGServerAdminForViewServices();

    @GetMapping(path={"/view-services"})
    @Operation(summary="getConfiguredViewServices", description="Return the list of view services that are configured for this server.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omvs/"))
    public RegisteredOMAGServicesResponse getConfiguredViewServices(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.getConfiguredViewServices(userId, serverName);
    }

    @GetMapping(path={"/view-services/configuration"})
    @Operation(summary="getViewServicesConfiguration", description="Return the view services configuration for this server.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omvs/"))
    public ViewServicesResponse getViewServicesConfiguration(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.getViewServicesConfiguration(userId, serverName);
    }

    @PostMapping(path={"/view-services/configuration"})
    @Operation(summary="setViewServicesConfiguration", description="Add the view services configuration for this server as a single call.  This operation is used for editing existing view service configuration.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omvs/"))
    public VoidResponse setViewServicesConfiguration(@PathVariable String userId, @PathVariable String serverName, @RequestBody List<ViewServiceConfig> viewServiceConfigs) {
        return this.adminAPI.setViewServicesConfiguration(userId, serverName, viewServiceConfigs);
    }

    @GetMapping(value={"/view-services/{serviceURLMarker}"})
    @Operation(summary="getViewServiceConfig", description="Return the view services configuration for this server.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omvs/"))
    public ViewServiceConfigResponse getViewServiceConfig(@PathVariable String userId, @PathVariable String serverName, @PathVariable String serviceURLMarker) {
        return this.adminAPI.getViewServiceConfig(userId, serverName, serviceURLMarker);
    }

    @PostMapping(path={"/view-services/{serviceURLMarker}"})
    @Operation(summary="configureViewService", description="Configure a single view service.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omvs/"))
    public VoidResponse configureViewService(@PathVariable String userId, @PathVariable String serverName, @PathVariable String serviceURLMarker, @RequestBody ViewServiceRequestBody requestBody) {
        return this.adminAPI.configureViewService(userId, serverName, serviceURLMarker, requestBody);
    }

    @PostMapping(path={"/view-services"})
    @Operation(summary="configureAllViewServices", description="Enable all view services that are registered with this OMAG server platform.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omvs/"))
    public VoidResponse configureAllViewServices(@PathVariable String userId, @PathVariable String serverName, @RequestBody ViewServiceRequestBody requestBody) {
        return this.adminAPI.configureAllViewServices(userId, serverName, requestBody);
    }

    @DeleteMapping(path={"/view-services/{serviceURLMarker}"})
    @Operation(summary="clearViewService", description="Remove the config for a view service.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omvs/"))
    public VoidResponse clearViewService(@PathVariable String userId, @PathVariable String serverName, @PathVariable String serviceURLMarker) {
        return this.adminAPI.clearViewService(userId, serverName, serviceURLMarker);
    }

    @DeleteMapping(path={"/view-services"})
    @Operation(summary="clearAllViewServices", description="Disable the view services.  This removes all configuration for the view services.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omvs/"))
    public VoidResponse clearAllViewServices(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.clearAllViewServices(userId, serverName);
    }
}

