/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.adminservices.rest.OMAGServerConfigsResponse;
import org.odpi.openmetadata.adminservices.server.OMAGServerAdminServices;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/open-metadata/admin-services/users/{userId}/configurations"})
@Tag(name="Administration Services - Server Configuration", description="The server configurations administration services support the configuration of the open metadata and governance services within an OMAG Server. A configuration determines which of the Open Metadata and Governance (OMAG) services are active.", externalDocs=@ExternalDocumentation(description="Further information", url="https://egeria-project.org/guides/admin/servers/"))
public class ConfigsResource {
    private final OMAGServerAdminServices adminAPI = new OMAGServerAdminServices();

    @GetMapping
    @Operation(summary="getStoredConfigurations", description="Return all the server configuration documents.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/configuration-document/"))
    public OMAGServerConfigsResponse getStoredConfigurations(@PathVariable String userId) {
        return this.adminAPI.retrieveAllServerConfigs(userId);
    }
}

