/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Map;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.rest.ConnectionResponse;
import org.odpi.openmetadata.adminservices.rest.OMAGServerConfigResponse;
import org.odpi.openmetadata.adminservices.server.OMAGServerAdminStoreServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.StringMapResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/open-metadata/admin-services/users/{userId}/stores"})
@Tag(name="Administration Services - Set up Configuration Document Store", description="Dynamically change the connector that accesses the configuration document store.  This overrides the value set in the application.properties (which overrides the default Encrypted File Configuration Document Store).", externalDocs=@ExternalDocumentation(description="Further information", url="https://egeria-project.org/services/admin-services/overview/#dynamically-configuring-the-configuration-document-store-connector"))
public class ConfigStoreResource {
    private final OMAGServerAdminStoreServices adminStoreAPI = new OMAGServerAdminStoreServices();

    @PostMapping(path={"/default-configuration-document"})
    @Operation(summary="setDefaultOMAGServerConfig", description="Override the default server configuration document.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/configuration-document/"))
    public VoidResponse setDefaultOMAGServerConfig(@PathVariable String userId, @RequestBody OMAGServerConfig defaultServerConfig) {
        return this.adminStoreAPI.setDefaultOMAGServerConfig(userId, defaultServerConfig);
    }

    @GetMapping(path={"/default-configuration-document"})
    @Operation(summary="getDefaultOMAGServerConfig", description="Return the default server configuration document.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/configuration-document/"))
    public OMAGServerConfigResponse getDefaultOMAGServerConfig(@PathVariable String userId) {
        return this.adminStoreAPI.getDefaultOMAGServerConfig(userId);
    }

    @DeleteMapping(path={"/default-configuration-document"})
    @Operation(summary="clearDefaultOMAGServerConfig", description="Clear the default configuration document.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/configuration-document/"))
    public VoidResponse clearDefaultOMAGServerConfig(@PathVariable String userId) {
        return this.adminStoreAPI.clearDefaultOMAGServerConfig(userId);
    }

    @PostMapping(path={"/placeholder-variables"})
    @Operation(summary="setPlaceholderVariables", description="Override the placeholder variables that will replace placeholders found in an OMAG server's configuration document at server start up.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/configuration-document/"))
    public VoidResponse setPlaceholderVariables(@PathVariable String userId, @RequestBody Map<String, String> placeholderVariables) {
        return this.adminStoreAPI.setPlaceholderVariables(userId, placeholderVariables);
    }

    @GetMapping(path={"/placeholder-variables"})
    @Operation(summary="getPlaceholderVariables", description="Return the placeholder variables that will replace placeholders found in an OMAG server's configuration document at server start up.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/configuration-document/"))
    public StringMapResponse getPlaceholderVariables(@PathVariable String userId) {
        return this.adminStoreAPI.getPlaceholderVariables(userId);
    }

    @DeleteMapping(path={"/placeholder-variables"})
    @Operation(summary="clearPlaceholderVariables", description="Clear the placeholder variables used whenever an OMAG Server is started.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/configuration-document/"))
    public VoidResponse clearPlaceholderVariables(@PathVariable String userId) {
        return this.adminStoreAPI.clearPlaceholderVariables(userId);
    }

    @PostMapping(path={"/connection"})
    @Operation(summary="setConfigurationStoreConnection", description="Override the default implementation or configuration of the configuration document store.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/configuration-document-store-connector/"))
    public VoidResponse setConfigurationStoreConnection(@PathVariable String userId, @RequestBody Connection connection) {
        return this.adminStoreAPI.setConfigurationStoreConnection(userId, connection);
    }

    @GetMapping(path={"/connection"})
    @Operation(summary="getConfigurationStoreConnection", description="Return the connection object for the configuration store.  Null is returned if the server should use the default store.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/configuration-document-store-connector/"))
    public ConnectionResponse getConfigurationStoreConnection(@PathVariable String userId) {
        return this.adminStoreAPI.getConfigurationStoreConnection(userId);
    }

    @DeleteMapping(path={"/connection"})
    @Operation(summary="clearConfigurationStoreConnection", description="Clear the connection object for the configuration store which means the platform uses the default store.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/configuration-document-store-connector/"))
    public VoidResponse clearConfigurationStoreConnection(@PathVariable String userId) {
        return this.adminStoreAPI.clearConfigurationStoreConnection(userId);
    }
}

