/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.integrationservices.analytics.contextmanager;

import java.util.Map;
import org.odpi.openmetadata.adminservices.configuration.properties.PermittedSynchronization;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.connectors.IntegrationConnector;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.contextmanager.IntegrationContextManager;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.registration.IntegrationServiceDescription;
import org.odpi.openmetadata.integrationservices.analytics.connector.AnalyticsIntegratorConnector;
import org.odpi.openmetadata.integrationservices.analytics.connector.AnalyticsIntegratorContext;
import org.odpi.openmetadata.integrationservices.analytics.ffdc.AnalyticsIntegratorAuditCode;
import org.odpi.openmetadata.integrationservices.analytics.ffdc.AnalyticsIntegratorErrorCode;

public class AnalyticsIntegratorContextManager
extends IntegrationContextManager {
    public void initializeContextManager(String partnerOMASServerName, String partnerOMASPlatformRootURL, String userId, String password, Map<String, Object> serviceOptions, int maxPageSize, AuditLog auditLog) {
        super.initializeContextManager(partnerOMASServerName, partnerOMASPlatformRootURL, userId, password, serviceOptions, maxPageSize, auditLog);
        String methodName = "initializeContextManager";
        auditLog.logMessage("initializeContextManager", AnalyticsIntegratorAuditCode.CONTEXT_INITIALIZING.getMessageDefinition(new String[]{partnerOMASServerName, partnerOMASPlatformRootURL}));
    }

    public void createClients() throws InvalidParameterException {
    }

    private String setUpMetadataSource(String metadataSourceQualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String metadataSourceQualifiedNameParameterName = "metadataSourceQualifiedName";
        String methodName = "setUpMetadataSource";
        InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
        invalidParameterHandler.validateName(metadataSourceQualifiedName, "metadataSourceQualifiedName", "setUpMetadataSource");
        return null;
    }

    public void setContext(String connectorId, String connectorName, String metadataSourceQualifiedName, IntegrationConnector integrationConnector, PermittedSynchronization permittedSynchronization) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setContext";
        String permittedSynchronizationName = PermittedSynchronization.BOTH_DIRECTIONS.getName();
        String serviceOptionsString = "null";
        if (permittedSynchronization != null) {
            permittedSynchronizationName = permittedSynchronization.getName();
        }
        if (this.serviceOptions != null) {
            serviceOptionsString = this.serviceOptions.toString();
        }
        if (!(integrationConnector instanceof AnalyticsIntegratorConnector)) {
            String parameterName = "integrationConnector";
            throw new InvalidParameterException(AnalyticsIntegratorErrorCode.INVALID_CONNECTOR.getMessageDefinition(new String[]{connectorName, IntegrationServiceDescription.ANALYTICS_INTEGRATOR_OMIS.getIntegrationServiceFullName(), AnalyticsIntegratorConnector.class.getCanonicalName()}), ((Object)((Object)this)).getClass().getName(), "setContext", "integrationConnector");
        }
        this.auditLog.logMessage("setContext", AnalyticsIntegratorAuditCode.CONNECTOR_CONTEXT_INITIALIZING.getMessageDefinition(new String[]{connectorName, connectorId, metadataSourceQualifiedName, permittedSynchronizationName, serviceOptionsString}));
        AnalyticsIntegratorConnector serviceSpecificConnector = (AnalyticsIntegratorConnector)integrationConnector;
        String metadataSourceGUID = this.setUpMetadataSource(metadataSourceQualifiedName);
        serviceSpecificConnector.setContext(new AnalyticsIntegratorContext(this.localServerUserId, metadataSourceGUID, metadataSourceQualifiedName));
    }
}

