/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.integrationservices.analytics.contextmanager;

import java.util.Map;
import org.odpi.openmetadata.accessservices.datascience.client.GovernanceConfigurationClient;
import org.odpi.openmetadata.accessservices.datascience.client.OpenGovernanceClient;
import org.odpi.openmetadata.accessservices.datascience.client.OpenIntegrationServiceClient;
import org.odpi.openmetadata.accessservices.datascience.client.OpenMetadataStoreClient;
import org.odpi.openmetadata.adminservices.configuration.registration.IntegrationServiceDescription;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.integration.connectors.IntegrationConnector;
import org.odpi.openmetadata.frameworks.integration.context.IntegrationContext;
import org.odpi.openmetadata.frameworks.integration.contextmanager.IntegrationContextManager;
import org.odpi.openmetadata.frameworks.openmetadata.enums.PermittedSynchronization;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.integrationservices.analytics.connector.AnalyticsIntegratorConnector;
import org.odpi.openmetadata.integrationservices.analytics.connector.AnalyticsIntegratorContext;
import org.odpi.openmetadata.integrationservices.analytics.ffdc.AnalyticsIntegratorAuditCode;
import org.odpi.openmetadata.integrationservices.analytics.ffdc.AnalyticsIntegratorErrorCode;

public class AnalyticsIntegratorContextManager
extends IntegrationContextManager {
    public void initializeContextManager(String partnerOMASServerName, String partnerOMASPlatformRootURL, String userId, String password, Map<String, Object> serviceOptions, int maxPageSize, AuditLog auditLog) {
        super.initializeContextManager(partnerOMASServerName, partnerOMASPlatformRootURL, userId, password, serviceOptions, maxPageSize, auditLog);
        String methodName = "initializeContextManager";
        auditLog.logMessage("initializeContextManager", AnalyticsIntegratorAuditCode.CONTEXT_INITIALIZING.getMessageDefinition(new String[]{partnerOMASServerName, partnerOMASPlatformRootURL}));
    }

    public void createClients(int maxPageSize) throws InvalidParameterException {
        this.openIntegrationClient = new OpenIntegrationServiceClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, maxPageSize);
        this.openMetadataStoreClient = new OpenMetadataStoreClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, maxPageSize);
        this.actionControlInterface = new OpenGovernanceClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, maxPageSize);
        this.governanceConfiguration = new GovernanceConfigurationClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, maxPageSize);
    }

    public IntegrationContext setContext(String connectorId, String connectorName, String connectorUserId, IntegrationConnector integrationConnector, String integrationConnectorGUID, PermittedSynchronization permittedSynchronization, boolean generateIntegrationReport, String metadataSourceQualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setContext";
        String permittedSynchronizationName = PermittedSynchronization.BOTH_DIRECTIONS.getName();
        String serviceOptionsString = "null";
        if (permittedSynchronization != null) {
            permittedSynchronizationName = permittedSynchronization.getName();
        }
        if (this.serviceOptions != null) {
            serviceOptionsString = this.serviceOptions.toString();
        }
        if (integrationConnector instanceof AnalyticsIntegratorConnector) {
            AnalyticsIntegratorConnector serviceSpecificConnector = (AnalyticsIntegratorConnector)integrationConnector;
            this.auditLog.logMessage("setContext", AnalyticsIntegratorAuditCode.CONNECTOR_CONTEXT_INITIALIZING.getMessageDefinition(new String[]{connectorName, connectorId, metadataSourceQualifiedName, permittedSynchronizationName, serviceOptionsString}));
            String externalSourceGUID = this.setUpMetadataSource(metadataSourceQualifiedName, null, null, null);
            String externalSourceName = metadataSourceQualifiedName;
            if (externalSourceGUID == null) {
                externalSourceName = null;
            }
            AnalyticsIntegratorContext integratorContext = new AnalyticsIntegratorContext(connectorId, connectorName, connectorUserId, this.partnerOMASServerName, this.openIntegrationClient, this.governanceConfiguration, this.openMetadataStoreClient, this.actionControlInterface, generateIntegrationReport, permittedSynchronization, integrationConnectorGUID, externalSourceGUID, externalSourceName, this.auditLog, this.maxPageSize);
            serviceSpecificConnector.setContext(integratorContext);
            integrationConnector.setConnectorName(connectorName);
            return integratorContext;
        }
        String parameterName = "integrationConnector";
        throw new InvalidParameterException(AnalyticsIntegratorErrorCode.INVALID_CONNECTOR.getMessageDefinition(new String[]{connectorName, IntegrationServiceDescription.ANALYTICS_INTEGRATOR_OMIS.getIntegrationServiceFullName(), AnalyticsIntegratorConnector.class.getCanonicalName()}), ((Object)((Object)this)).getClass().getName(), "setContext", "integrationConnector");
    }
}

