/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.analyticsmodeling.test.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.testng.Assert;

public class TestUtilities {
    public static void assertObjectJson(Object ds, String master) {
        ObjectMapper om = new ObjectMapper();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            om.writerWithDefaultPrettyPrinter().writeValue((OutputStream)baos, ds);
        }
        catch (IOException e) {
            Assert.fail((String)("Can't write JSON for object " + ds.getClass().getName()));
        }
        String output = new String(baos.toByteArray(), StandardCharsets.UTF_8);
        Assert.assertEquals((String)master, (String)output, (String)(ds.getClass().getName() + " json failed."));
    }

    public static <T> T readObjectJson(String json, Class<T> cls) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return (T)mapper.readValue(json, cls);
        }
        catch (JsonProcessingException e) {
            Assert.fail((String)("Can't read from JSON object " + cls.getName()));
            return null;
        }
    }

    public static String readJsonFile(String folder, String fileName) throws IOException {
        String root = Paths.get(".", new String[0]).toAbsolutePath().normalize().toString();
        String input = root + folder + fileName + ".json";
        return new String(Files.readAllBytes(Paths.get(input, new String[0])));
    }
}

