/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.analyticsmodeling.test.model.module;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.module.DataSource;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.module.MetadataModule;
import org.odpi.openmetadata.accessservices.analyticsmodeling.test.utils.TestUtilities;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ModuleTest {
    private static final String IDENTIFIER = "IDENTIFIER";
    private static final String VERSION = "9.0";
    String master = String.format("{%n  \"identifier\" : \"IDENTIFIER\",%n  \"version\" : \"9.0\",%n  \"dataSource\" : [ { }, { } ]%n}", new Object[0]);
    String master_empty = String.format("{%n  \"version\" : \"9.0\"%n}", new Object[0]);
    List<DataSource> sources = Arrays.asList(new DataSource(), new DataSource());

    @Test
    public void toJson() {
        MetadataModule obj = new MetadataModule();
        obj.setIdentifier(IDENTIFIER);
        obj.setDataSource(this.sources);
        TestUtilities.assertObjectJson(obj, this.master);
    }

    @Test
    public void toJsonEmpty() {
        TestUtilities.assertObjectJson(new MetadataModule(), this.master_empty);
    }

    @Test
    public void fromJson() {
        MetadataModule obj = TestUtilities.readObjectJson(this.master, MetadataModule.class);
        Assert.assertEquals((String)IDENTIFIER, (String)obj.getIdentifier());
        Assert.assertEquals((String)VERSION, (String)obj.getVersion());
        Assert.assertEquals((int)2, (int)obj.getDataSource().size());
        TestUtilities.assertObjectJson(obj, this.master);
    }

    @Test
    public void completeModule() throws IOException {
        String module = TestUtilities.readJsonFile("/src/test/resources/", "completeModule");
        MetadataModule obj = TestUtilities.readObjectJson(module, MetadataModule.class);
        Assert.assertEquals((String)"AdventureWorks2014.Person", (String)obj.getIdentifier());
        Assert.assertEquals((String)VERSION, (String)obj.getVersion());
        Assert.assertEquals((int)1, (int)obj.getDataSource().size());
        TestUtilities.assertObjectJson(obj, module);
    }
}

