/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.analyticsmodeling.test.model.module;

import java.util.Arrays;
import java.util.List;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.module.DataSource;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.module.Table;
import org.odpi.openmetadata.accessservices.analyticsmodeling.test.utils.TestUtilities;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DataSourceTest {
    private static final String DATASOURCE_NAME = "DATASOURCE_NAME";
    private static final String SCHEMA = "SCHEMA";
    private static final String CATALOG = "CATALOG";
    String master = String.format("{%n  \"schema\" : \"SCHEMA\",%n  \"catalog\" : \"CATALOG\",%n  \"name\" : \"DATASOURCE_NAME\",%n  \"table\" : [ { }, { } ]%n}", new Object[0]);
    String master_empty = "{ }";
    List<Table> tables = Arrays.asList(new Table(), new Table());

    @Test
    public void toJson() {
        DataSource obj = new DataSource();
        obj.setName(DATASOURCE_NAME);
        obj.setCatalog(CATALOG);
        obj.setSchema(SCHEMA);
        obj.setTable(this.tables);
        TestUtilities.assertObjectJson(obj, this.master);
    }

    @Test
    public void toJsonEmpty() {
        TestUtilities.assertObjectJson(new DataSource(), this.master_empty);
    }

    @Test
    public void fromJson() {
        DataSource obj = TestUtilities.readObjectJson(this.master, DataSource.class);
        Assert.assertEquals((String)DATASOURCE_NAME, (String)obj.getName());
        Assert.assertEquals((String)SCHEMA, (String)obj.getSchema());
        Assert.assertEquals((String)CATALOG, (String)obj.getCatalog());
        Assert.assertEquals((int)2, (int)obj.getTable().size());
        TestUtilities.assertObjectJson(obj, this.master);
    }
}

