/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.analyticsmodeling.test.responses;

import org.odpi.openmetadata.accessservices.analyticsmodeling.ffdc.AnalyticsModelingErrorCode;
import org.odpi.openmetadata.accessservices.analyticsmodeling.ffdc.exceptions.AnalyticsModelingCheckedException;
import org.odpi.openmetadata.accessservices.analyticsmodeling.responses.ErrorResponse;
import org.odpi.openmetadata.accessservices.analyticsmodeling.test.utils.TestUtilities;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ErrorResponseTest {
    private static final String MESSAGE = "short message";
    private static final String CODE = "MSR_OMS_001";
    private static final String EXCEPTIONCAUSE = "com.ibm.AppException: Cannot open ...";
    String master = String.format("{%n  \"class\" : \"ErrorResponse\",%n  \"relatedHTTPCode\" : 500,%n  \"msg\" : \"short message\",%n  \"code\" : \"MSR_OMS_001\",%n  \"exceptionCauseMsg\" : \"com.ibm.AppException: Cannot open ...\"%n}", new Object[0]);

    @Test
    public void toJson() {
        AnalyticsModelingCheckedException ex = new AnalyticsModelingCheckedException(AnalyticsModelingErrorCode.INCORRECT_MODEL_EXCEPTION.getMessageDefinition(new String[]{"guidEntity", "error description"}), "ErrorResponse", "");
        ErrorResponse er = new ErrorResponse(ex);
        er.setMessage(MESSAGE);
        er.setErrorCode(CODE);
        er.setExceptionCause(EXCEPTIONCAUSE);
        TestUtilities.assertObjectJson(er, this.master);
    }

    @Test
    public void fromJson() {
        ErrorResponse er = TestUtilities.readObjectJson(this.master, ErrorResponse.class);
        Assert.assertEquals((String)MESSAGE, (String)er.getMessage());
        Assert.assertEquals((String)CODE, (String)er.getErrorCode());
        Assert.assertEquals((String)EXCEPTIONCAUSE, (String)er.getExceptionCause());
    }
}

