/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.analyticsmodeling.responses;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.accessservices.analyticsmodeling.ffdc.exceptions.AnalyticsModelingCheckedException;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.response.AnalyticsMessage;
import org.odpi.openmetadata.accessservices.analyticsmodeling.responses.AnalyticsModelingOMASAPIResponse;

public class ErrorResponse
extends AnalyticsModelingOMASAPIResponse {
    private List<AnalyticsMessage> errors;

    public ErrorResponse() {
    }

    public ErrorResponse(AnalyticsModelingCheckedException source) {
        this.setRelatedHTTPCode(source.getReportedHTTPCode());
        AnalyticsMessage error = AnalyticsMessage.createError(Integer.toString(source.getReportedHTTPCode()), source.getReportedErrorMessageId(), source.getMessage(), source.getErrorCause());
        this.errors = new ArrayList<AnalyticsMessage>();
        this.errors.add(error);
    }

    public List<AnalyticsMessage> getErrors() {
        return this.errors;
    }

    protected void setErrors(List<AnalyticsMessage> errors) {
        this.errors = errors;
    }

    public void addError(String messageId, String httpStatus, String message, String detail) {
        if (this.errors == null) {
            this.errors = new ArrayList<AnalyticsMessage>();
        }
        AnalyticsMessage error = new AnalyticsMessage();
        this.errors.add(error);
        error.setCode(messageId);
        error.setStatus(httpStatus);
        error.setTitle(message);
        error.setDetail(detail);
    }
}

