/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.analyticsmodeling.test.model.module;

import org.odpi.openmetadata.accessservices.analyticsmodeling.model.module.Column;
import org.odpi.openmetadata.accessservices.analyticsmodeling.test.utils.TestUtilities;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ColumnTest {
    private static final String DATA_TYPE = "DATA_TYPE";
    private static final String VENDOR_TYPE = "VENDOR_TYPE";
    private static final String COLUMN_NAME = "COLUMN_NAME";
    String master = String.format("{%n  \"name\" : \"COLUMN_NAME\",%n  \"vendorType\" : \"VENDOR_TYPE\",%n  \"nullable\" : true,%n  \"datatype\" : \"DATA_TYPE\"%n}", new Object[0]);
    String master_empty = "{ }";

    @Test
    public void toJson() {
        Column obj = new Column();
        obj.setName(COLUMN_NAME);
        obj.setNullable(Boolean.valueOf(true));
        obj.setVendorType(VENDOR_TYPE);
        obj.setDatatype(DATA_TYPE);
        TestUtilities.assertObjectJson(obj, this.master);
    }

    @Test
    public void toJsonEmpty() {
        Column obj = new Column();
        TestUtilities.assertObjectJson(obj, this.master_empty);
    }

    @Test
    public void fromJson() {
        Column obj = TestUtilities.readObjectJson(this.master, Column.class);
        Assert.assertEquals((String)COLUMN_NAME, (String)obj.getName());
        Assert.assertEquals((Object)Boolean.TRUE, (Object)obj.isNullable());
        Assert.assertEquals((String)VENDOR_TYPE, (String)obj.getVendorType());
        Assert.assertEquals((String)DATA_TYPE, (String)obj.getDatatype());
    }
}

