/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.analyticsmodeling.test.model.module;

import java.util.Arrays;
import java.util.List;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.module.ForeignKey;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.module.PrimaryKey;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.module.Table;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.module.TableItem;
import org.odpi.openmetadata.accessservices.analyticsmodeling.test.utils.TestUtilities;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TableTest {
    private static final String TABLE_NAME = "TABLE_NAME";
    String master = String.format("{%n  \"name\" : \"TABLE_NAME\",%n  \"tableItem\" : [ { }, { } ],%n  \"foreignKey\" : [ { }, { } ],%n  \"primaryKey\" : [ { }, { } ]%n}", new Object[0]);
    String master_empty = "{ }";
    List<TableItem> columns = Arrays.asList(new TableItem(), new TableItem());
    List<ForeignKey> foreignKey = Arrays.asList(new ForeignKey(), new ForeignKey());
    List<PrimaryKey> primaryKey = Arrays.asList(new PrimaryKey(), new PrimaryKey());

    @Test
    public void toJson() {
        Table obj = new Table();
        obj.setName(TABLE_NAME);
        obj.setTableItem(this.columns);
        obj.setForeignKey(this.foreignKey);
        obj.setPrimaryKey(this.primaryKey);
        TestUtilities.assertObjectJson(obj, this.master);
    }

    @Test
    public void toJsonEmpty() {
        TestUtilities.assertObjectJson(new Table(), this.master_empty);
    }

    @Test
    public void fromJson() {
        Table obj = TestUtilities.readObjectJson(this.master, Table.class);
        Assert.assertEquals((String)TABLE_NAME, (String)obj.getName());
        Assert.assertEquals((int)2, (int)obj.getForeignKey().size());
        Assert.assertEquals((int)2, (int)obj.getPrimaryKey().size());
        Assert.assertEquals((int)2, (int)obj.getTableItem().size());
        TestUtilities.assertObjectJson(obj, this.master);
    }
}

