/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.analyticsmodeling.test.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.ResponseContainerModule;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.module.BaseObjectType;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.module.Column;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.module.DataSource;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.module.MetadataModule;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.module.PropertyType;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.module.Table;
import org.testng.Assert;

public class TestUtilities {
    public static void assertObjectJson(Object ds, String master) {
        String output = TestUtilities.writeObjectJson(ds);
        Assert.assertEquals((String)output, (String)master, (String)(ds.getClass().getName() + " json failed."));
    }

    public static String writeObjectJson(Object ds) {
        ObjectMapper om = new ObjectMapper();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            om.writerWithDefaultPrettyPrinter().writeValue((OutputStream)baos, ds);
        }
        catch (IOException e) {
            Assert.fail((String)("Can't write JSON for object " + ds.getClass().getName()));
        }
        return new String(baos.toByteArray(), StandardCharsets.UTF_8);
    }

    public static <T> T readObjectJson(String json, Class<T> cls) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return (T)mapper.readValue(json, cls);
        }
        catch (JsonProcessingException e) {
            Assert.fail((String)("Can't read from JSON object " + cls.getName() + ":\n" + e.getMessage()));
            return null;
        }
    }

    public static String readJsonFile(String folder, String fileName) throws IOException {
        String root = Paths.get(".", new String[0]).toAbsolutePath().normalize().toString();
        String input = root + folder + fileName + ".json";
        return new String(Files.readAllBytes(Paths.get(input, new String[0])));
    }

    public static void validateGUIDs(ResponseContainerModule moduleResponse) {
        MetadataModule module = moduleResponse.getPhysicalModule();
        HashSet<String> guids = new HashSet<String>();
        TestUtilities.fixGUID((BaseObjectType)module, guids);
        module.getDataSource().forEach(ds -> {
            TestUtilities.fixGUID((BaseObjectType)ds, guids);
            Optional.ofNullable(ds.getTable()).orElse(Collections.emptyList()).forEach(tbl -> {
                TestUtilities.fixGUID((BaseObjectType)tbl, guids);
                Optional.ofNullable(tbl.getTableItem()).orElse(Collections.emptyList()).forEach(item -> TestUtilities.fixGUID((BaseObjectType)item.getColumn(), guids));
            });
        });
    }

    private static void fixGUID(BaseObjectType object, HashSet<String> guids) {
        PropertyType guid = object.getPropertyByName("guid");
        if (guid == null) {
            return;
        }
        Assert.assertFalse((boolean)guids.contains(guid.getValue()), (String)"Not unique guid.");
        guids.add(guid.getValue());
        guid.setValue(TestUtilities.generateGUID(object));
        PropertyType term = object.getPropertyByName("GlossaryTerm");
        if (term == null) {
            return;
        }
        String value = term.getValue().replaceFirst("\\\"guid\\\":\\\"[0-9abcdef\\-]+\\\"", String.format("\\\"guid\":\"GlossaryTerm_%s\"", guid.getValue()));
        term.setValue(value);
    }

    private static String generateGUID(BaseObjectType object) {
        String prefix = object.getClass().getSimpleName() + "@";
        if (object instanceof Column) {
            return prefix + ((Column)object).getName();
        }
        if (object instanceof Table) {
            return prefix + ((Table)object).getName();
        }
        if (object instanceof DataSource) {
            return prefix + ((DataSource)object).getName();
        }
        if (object instanceof MetadataModule) {
            return prefix + ((MetadataModule)object).getIdentifier();
        }
        Assert.fail((String)("Unknown class: " + object.getClass().getName()));
        return null;
    }
}

