/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.analyticsmodeling.model.response;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.TreeMap;
import org.odpi.openmetadata.frameworks.auditlog.MessageFormatter;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.MessageDefinition;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class AnalyticsMessage {
    private static final String ERROR = "error";
    private static final String SEVERITY = "severity";
    private static final MessageFormatter messageFormatter = new MessageFormatter();
    String status;
    String code;
    String title;
    String detail;
    TreeMap<String, String> meta;

    public AnalyticsMessage() {
        this.setSeverity(ERROR);
    }

    private AnalyticsMessage(String severity, ExceptionMessageDefinition message) {
        this.status = Integer.toString(message.getHttpErrorCode());
        this.code = message.getMessageId();
        this.title = messageFormatter.getFormattedMessage((MessageDefinition)message);
        this.detail = message.getSystemAction() + " " + message.getUserAction();
        this.setSeverity(severity);
    }

    public static AnalyticsMessage createError(String status, String code, String title, String detail) {
        AnalyticsMessage ret = new AnalyticsMessage();
        ret.status = status;
        ret.code = code;
        ret.title = title;
        ret.detail = detail;
        ret.setSeverity(ERROR);
        return ret;
    }

    public static AnalyticsMessage createError(ExceptionMessageDefinition message) {
        return new AnalyticsMessage(ERROR, message);
    }

    public static AnalyticsMessage createWarning(ExceptionMessageDefinition message) {
        return new AnalyticsMessage("warning", message);
    }

    public static AnalyticsMessage createInfo(ExceptionMessageDefinition message) {
        return new AnalyticsMessage("info", message);
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String value) {
        this.status = value;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String value) {
        this.code = value;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String value) {
        this.title = value;
    }

    public String getDetail() {
        return this.detail;
    }

    public void setDetail(String value) {
        this.detail = value;
    }

    public TreeMap<String, String> getMeta() {
        return this.meta;
    }

    public void setMeta(TreeMap<String, String> value) {
        this.meta = value;
    }

    public void setSeverity(String value) {
        if (this.meta == null) {
            this.meta = new TreeMap();
        }
        this.meta.put(SEVERITY, value);
    }
}

