/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.analyticsmodeling.test.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.ModuleTableFilter;
import org.odpi.openmetadata.accessservices.analyticsmodeling.test.utils.JsonMocks;
import org.odpi.openmetadata.accessservices.analyticsmodeling.test.utils.TestUtilities;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ModuleTableFilterTest {
    private List<String> tables = Arrays.asList("ORDERDETAIL", "PRODUCT");

    @Test
    public void toJsonExcludedTables() {
        ModuleTableFilter obj = new ModuleTableFilter();
        obj.getMeta().setExcludedTables(this.tables);
        TestUtilities.assertObjectJson(obj, JsonMocks.getModuleTableExcludedFilterBody());
    }

    @Test
    public void toJsonIncludedTables() {
        ModuleTableFilter obj = new ModuleTableFilter();
        obj.getMeta().setIncludedTables(this.tables);
        TestUtilities.assertObjectJson(obj, JsonMocks.getModuleTableIncludedFilterBody());
    }

    @Test
    public void fromJsonExcludedTables() {
        ModuleTableFilter obj = TestUtilities.readObjectJson(JsonMocks.getModuleTableExcludedFilterBody(), ModuleTableFilter.class);
        Assert.assertEquals(this.tables, (Collection)obj.getMeta().getExcludedTables());
        Assert.assertNull((Object)obj.getMeta().getIncludedTables());
    }

    @Test
    public void fromJsonIncludedTables() {
        ModuleTableFilter obj = TestUtilities.readObjectJson(JsonMocks.getModuleTableIncludedFilterBody(), ModuleTableFilter.class);
        Assert.assertEquals(this.tables, (Collection)obj.getMeta().getIncludedTables());
        Assert.assertNull((Object)obj.getMeta().getExcludedTables());
    }

    @Test
    public void filterIncludedTables() {
        ModuleTableFilter obj = TestUtilities.readObjectJson(JsonMocks.getModuleTableIncludedFilterBody(), ModuleTableFilter.class);
        Assert.assertTrue((boolean)obj.match(this.tables.get(0)));
        Assert.assertFalse((boolean)obj.match("NOT_INCLUDED_TABLE"));
    }

    @Test
    public void filterExcludedTables() {
        ModuleTableFilter obj = TestUtilities.readObjectJson(JsonMocks.getModuleTableExcludedFilterBody(), ModuleTableFilter.class);
        Assert.assertFalse((boolean)obj.match(this.tables.get(0)));
        Assert.assertTrue((boolean)obj.match("NOT_EXCLUDED_TABLE"));
    }

    @Test
    public void filterEmptyTables() {
        ModuleTableFilter obj = new ModuleTableFilter();
        Assert.assertTrue((boolean)obj.match(this.tables.get(0)));
    }
}

