/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.analyticsmodeling.test.model.module;

import java.util.Arrays;
import java.util.List;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.module.ForeignColumn;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.module.ForeignKey;
import org.odpi.openmetadata.accessservices.analyticsmodeling.test.utils.TestUtilities;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ForeignKeyTest {
    private static final String FK_NAME = "FK_NAME";
    String master = String.format("{%n  \"name\" : \"FK_NAME\",%n  \"fkColumn\" : [ {%n    \"columnName\" : \"A\"%n  }, {%n    \"columnName\" : \"B\"%n  } ]%n}", new Object[0]);
    String master_empty = "{ }";
    List<ForeignColumn> columns = Arrays.asList(this.newNamedFK("A"), this.newNamedFK("B"));

    ForeignColumn newNamedFK(String name) {
        ForeignColumn ret = new ForeignColumn();
        ret.setColumnName(name);
        return ret;
    }

    @Test
    public void toJson() {
        ForeignKey obj = new ForeignKey();
        obj.setName(FK_NAME);
        obj.setFkColumn(this.columns);
        TestUtilities.assertObjectJson(obj, this.master);
    }

    @Test
    public void toJsonEmpty() {
        TestUtilities.assertObjectJson(new ForeignColumn(), this.master_empty);
    }

    @Test
    public void fromJson() {
        ForeignKey obj = TestUtilities.readObjectJson(this.master, ForeignKey.class);
        Assert.assertEquals((String)FK_NAME, (String)obj.getName());
        Assert.assertEquals((int)2, (int)obj.getFkColumn().size());
        Assert.assertEquals((String)"A", (String)((ForeignColumn)obj.getFkColumn().get(0)).getColumnName());
        TestUtilities.assertObjectJson(obj, this.master);
    }
}

